/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.repeatable.WhereSpecifications;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpression;
import io.micronaut.data.model.naming.NamingStrategies;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public final class CosmosSqlQueryBuilder
extends SqlQueryBuilder {
    private static final NamingStrategy RAW_NAMING_STRATEGY = new NamingStrategies.Raw();
    private static final String JOIN = " JOIN ";
    private static final String IN = " IN ";

    @Creator
    public CosmosSqlQueryBuilder(AnnotationMetadata annotationMetadata) {
        super(annotationMetadata);
    }

    protected String asLiteral(Object value) {
        if (value instanceof Boolean) {
            return value.toString();
        }
        return super.asLiteral(value);
    }

    protected boolean traverseEmbedded() {
        return false;
    }

    protected SqlQueryBuilder.SqlSelectionVisitor createSelectionVisitor(AnnotationMetadata annotationMetadata, AbstractSqlLikeQueryBuilder.QueryState queryState, boolean distinct) {
        return new SqlQueryBuilder.SqlSelectionVisitor(this, queryState, annotationMetadata, distinct){
            private static final String VALUE = "VALUE ";
            private static final String SELECT_COUNT = "COUNT(1)";

            protected void appendRowCount(String logicalName) {
                this.query.append(SELECT_COUNT);
            }

            protected void appendRowCountDistinct(String logicalName) {
                throw new UnsupportedOperationException("Count distinct is not supported by Micronaut Data Azure Cosmos.");
            }

            protected void selectAllColumnsFromJoinPaths(Collection<JoinPath> allPaths, Map<JoinPath, String> joinAliasOverride) {
            }

            protected void appendPropertyProjection(AbstractSqlLikeQueryBuilder.QueryPropertyPath propertyPath) {
                this.query.append(VALUE);
                super.appendPropertyProjection(propertyPath);
            }

            protected void appendAssociationProjection(PersistentAssociationPath associationPath) {
                String joinedPath = associationPath.getPath();
                if (!this.queryState.isJoined(joinedPath)) {
                    this.query.setLength(this.query.length() - 1);
                    return;
                }
                String joinAlias = this.queryState.getJoinAlias(associationPath.getPath());
                this.selectAllColumns(AnnotationMetadata.EMPTY_METADATA, associationPath.getAssociation().getAssociatedEntity(), joinAlias);
            }

            protected void selectAllColumnsAndJoined() {
                this.query.append("DISTINCT ").append(VALUE).append(this.queryState.getRootAlias());
            }

            public void visit(UnaryExpression<?> unaryExpression) {
                this.query.append(VALUE);
                super.visit(unaryExpression);
            }
        };
    }

    protected AbstractSqlLikeQueryBuilder.SqlPredicateVisitor createPredicateVisitor(AnnotationMetadata annotationMetadata, AbstractSqlLikeQueryBuilder.QueryState queryState) {
        return new AbstractSqlLikeQueryBuilder.SqlPredicateVisitor(this, queryState, annotationMetadata){
            private static final String IS_NULL = "IS_NULL";
            private static final String IS_DEFINED = "IS_DEFINED";
            private static final String ARRAY_CONTAINS = "ARRAY_CONTAINS";

            public void visitIsNull(Expression<?> expression) {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(expression).getPropertyPath();
                this.query.append("NOT").append(' ').append(IS_DEFINED).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')').append(' ').append("OR").append(' ');
                this.query.append(IS_NULL).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')');
            }

            public void visitIsNotNull(Expression<?> expression) {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(expression).getPropertyPath();
                this.query.append(IS_DEFINED).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')').append(' ').append("AND").append(' ');
                this.query.append("NOT").append(' ').append(IS_NULL).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')');
            }

            public void visitIsEmpty(Expression<?> expression) {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(expression).getPropertyPath();
                this.query.append("NOT").append(' ').append(IS_DEFINED).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')').append(' ').append("OR").append(' ');
                this.query.append(IS_NULL).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')').append(' ').append("OR").append(' ');
                this.appendPropertyRef(propertyPath);
                this.query.append(" = ").append("''");
            }

            public void visitIsNotEmpty(Expression<?> expression) {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(expression).getPropertyPath();
                this.query.append(IS_DEFINED).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')').append(' ').append("AND").append(' ');
                this.query.append("NOT").append(' ').append(IS_NULL).append('(');
                this.appendPropertyRef(propertyPath);
                this.query.append(')').append(' ').append("AND").append(' ');
                this.appendPropertyRef(propertyPath);
                this.query.append(" != ").append("''");
            }

            public void visitArrayContains(Expression<?> leftExpression, Expression<?> rightExpression) {
                PersistentPropertyPath leftProperty = CriteriaUtils.requireProperty(leftExpression).getPropertyPath();
                this.query.append(ARRAY_CONTAINS).append('(');
                this.appendPropertyRef(leftProperty);
                this.query.append(',');
                this.appendExpression(rightExpression, leftExpression);
                this.query.append(',');
                this.query.append("true").append(')');
            }
        };
    }

    protected NamingStrategy getNamingStrategy(PersistentEntity entity) {
        return entity.findNamingStrategy().orElse(RAW_NAMING_STRATEGY);
    }

    protected NamingStrategy getNamingStrategy(PersistentPropertyPath propertyPath) {
        return propertyPath.findNamingStrategy().orElse(RAW_NAMING_STRATEGY);
    }

    private void appendJoins(AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryBuffer, Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
        if (CollectionUtils.isEmpty(allPaths)) {
            return;
        }
        String logicalName = queryState.getRootAlias();
        HashMap<CallSite, String> joinedPaths = new HashMap<CallSite, String>();
        for (JoinPath joinPath : allPaths) {
            Association association = joinPath.getAssociation();
            if (association.isEmbedded()) continue;
            String joinAlias = joinAliasOverride == null ? this.getAliasName(joinPath) : joinAliasOverride.get(joinPath);
            String path = logicalName + "." + joinPath.getPath();
            for (Map.Entry entry : joinedPaths.entrySet()) {
                String joinedPath = (String)entry.getKey();
                String prefix = joinedPath + ".";
                if (!path.startsWith(prefix) || joinedPath.equals(path)) continue;
                path = (String)entry.getValue() + "." + path.replace(prefix, "");
                break;
            }
            queryBuffer.append(JOIN).append(joinAlias).append(IN).append(path);
            joinedPaths.put((CallSite)((Object)path), joinAlias);
        }
    }

    public QueryResult buildSelect(@NonNull AnnotationMetadata annotationMetadata, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull QueryBuilder.SelectQueryDefinition definition) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        AbstractSqlLikeQueryBuilder.QueryState queryState = new AbstractSqlLikeQueryBuilder.QueryState((AbstractSqlLikeQueryBuilder)this, (QueryBuilder.BaseQueryDefinition)definition, true, true);
        ArrayList joinPaths = new ArrayList(definition.getJoinPaths());
        joinPaths.sort((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare(o1.getPath(), o2.getPath()));
        for (JoinPath joinPath : joinPaths) {
            queryState.applyJoin(joinPath);
        }
        StringBuilder select = queryState.getQuery();
        select.append("SELECT ");
        this.buildSelect(annotationMetadata, queryState, definition.selection(), false);
        select.append(" FROM ").append(this.getTableName(queryState.getEntity())).append(' ').append(queryState.getRootAlias());
        this.appendJoins(queryState, select, definition.getJoinPaths(), null);
        Predicate predicate = definition.predicate();
        if (predicate != null || annotationMetadata.hasStereotype(WhereSpecifications.class) || queryState.getEntity().getAnnotationMetadata().hasStereotype(WhereSpecifications.class)) {
            this.buildWhereClause(annotationMetadata, predicate, queryState);
        }
        this.appendOrder(annotationMetadata, definition.order(), queryState);
        this.appendForUpdate(AbstractSqlLikeQueryBuilder.QueryPosition.END_OF_QUERY, definition, queryState.getQuery());
        return QueryResult.of((String)queryState.getFinalQuery(), (List)queryState.getQueryParts(), (List)queryState.getParameterBindings(), (int)definition.limit(), (long)definition.offset(), (Collection)queryState.getJoinPaths());
    }

    protected void buildJoin(String joinType, StringBuilder query, AbstractSqlLikeQueryBuilder.QueryState queryState, PersistentAssociationPath joinAssociation, PersistentEntity associationOwner, String currentJoinAlias, String lastJoinAlias) {
    }

    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append("SELECT * ").append(" FROM ");
    }

    protected boolean isAliasForBatch(PersistentEntity persistentEntity, AnnotationMetadata annotationMetadata) {
        return true;
    }

    protected boolean computePropertyPaths() {
        return false;
    }

    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, QueryBuilder.InsertQueryDefinition definition) {
        return null;
    }

    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryBuilder.UpdateQueryDefinition definition) {
        final QueryResult queryResult = super.buildUpdate(annotationMetadata, definition);
        String resultQuery = queryResult.getQuery();
        PersistentEntity entity = definition.persistentEntity();
        String tableAlias = this.getAliasName(entity);
        String tableName = this.getTableName(entity);
        final String finalQuery = "SELECT * FROM " + tableName + " " + tableAlias + " " + resultQuery.substring(resultQuery.toLowerCase(Locale.ROOT).indexOf("where"));
        StringJoiner stringJoiner = new StringJoiner(",");
        definition.propertiesToUpdate().keySet().forEach(stringJoiner::add);
        final String update = stringJoiner.toString();
        return new QueryResult(){

            public @NonNull String getQuery() {
                return finalQuery;
            }

            public String getUpdate() {
                return update;
            }

            public List<String> getQueryParts() {
                return queryResult.getQueryParts();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryResult.getParameterBindings();
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return queryResult.getAdditionalRequiredParameters();
            }
        };
    }

    public String buildLimitAndOffset(long limit, long offset) {
        if (limit > 0L) {
            return " OFFSET " + offset + " LIMIT " + limit + " ";
        }
        return "";
    }
}

