/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.FunctionExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.LikePredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.NegatedPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyInPredicate;
import io.micronaut.data.model.jpa.criteria.impl.selection.AliasedSelection;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.impl.AdvancedPredicateVisitor;
import io.micronaut.serde.config.annotation.SerdeConfig;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;

@TypeHint(value={MongoQueryBuilder2.class})
@Internal
public final class MongoQueryBuilder2
implements QueryBuilder2 {
    public static final String QUERY_PARAMETER_PLACEHOLDER = "$mn_qp";
    public static final String MONGO_DATE_IDENTIFIER = "$date";
    public static final String MONGO_ID_FIELD = "_id";
    private static final String REGEX = "$regex";
    private static final String NOT = "$not";
    private static final String OPTIONS = "$options";

    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, QueryBuilder2.InsertQueryDefinition insertQueryDefinition) {
        return null;
    }

    public QueryResult buildSelect(AnnotationMetadata annotationMetadata, final QueryBuilder2.SelectQueryDefinition selectQueryDefinition) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"selectQueryDefinition", (Object)selectQueryDefinition);
        final QueryState queryState = new QueryState((QueryBuilder2.BaseQueryDefinition)selectQueryDefinition, true);
        Map<Object, Object> predicateObj = new LinkedHashMap();
        LinkedHashMap<String, Object> group = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> projectionObj = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> countObj = new LinkedHashMap<String, Object>();
        this.addLookups(selectQueryDefinition.getJoinPaths(), queryState);
        List<Map<String, Object>> pipeline = queryState.rootLookups.pipeline;
        this.buildProjection(selectQueryDefinition.selection(), group, projectionObj, countObj);
        Predicate predicate = selectQueryDefinition.predicate();
        if (predicate != null) {
            predicateObj = this.buildWhereClause(predicate, queryState);
        }
        if (!predicateObj.isEmpty()) {
            pipeline.add(Map.of("$match", predicateObj));
        }
        if (!group.isEmpty()) {
            group.put(MONGO_ID_FIELD, null);
            pipeline.add(Map.of("$group", group));
        }
        if (!countObj.isEmpty()) {
            pipeline.add(countObj);
        }
        if (!projectionObj.isEmpty()) {
            pipeline.add(Map.of("$project", projectionObj));
        } else {
            String customProjection = annotationMetadata.stringValue("io.micronaut.data.mongodb.annotation.MongoProjection").orElse(null);
            if (customProjection != null) {
                pipeline.add(Map.of("$project", new RawJsonValue(customProjection)));
            }
        }
        List orders = selectQueryDefinition.order();
        if (!orders.isEmpty()) {
            LinkedHashMap sortObj = new LinkedHashMap();
            orders.forEach(order -> {
                PersistentPropertyPath persistentPropertyPath = CriteriaUtils.requireProperty((Expression)order.getExpression());
                sortObj.put(persistentPropertyPath.getPathAsString(), order.isAscending() ? 1 : -1);
            });
            pipeline.add(Map.of("$sort", sortObj));
        } else {
            String customSort = annotationMetadata.stringValue("io.micronaut.data.mongodb.annotation.MongoSort").orElse(null);
            if (customSort != null) {
                pipeline.add(Map.of("$sort", new RawJsonValue(customSort)));
            }
        }
        if (selectQueryDefinition.offset() > 0) {
            pipeline.add(Map.of("$skip", selectQueryDefinition.offset()));
        }
        if (selectQueryDefinition.limit() != -1) {
            pipeline.add(Map.of("$limit", selectQueryDefinition.limit()));
        }
        final String q = pipeline.isEmpty() ? "{}" : (this.isMatchOnlyStage(pipeline) ? this.toJsonString(predicateObj) : this.toJsonString(pipeline));
        return new QueryResult(){

            @NonNull
            public String getQuery() {
                return q;
            }

            public int getMax() {
                return selectQueryDefinition.limit();
            }

            public long getOffset() {
                return selectQueryDefinition.offset();
            }

            public List<String> getQueryParts() {
                return Collections.emptyList();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryState.getParameterBindings();
            }
        };
    }

    private void addLookups(Collection<JoinPath> joins, QueryState queryState) {
        if (joins.isEmpty()) {
            return;
        }
        List<String> joined = joins.stream().map(JoinPath::getPath).sorted((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare((String)o1, (String)o2)).toList();
        for (String join : joined) {
            StringJoiner rootPath = new StringJoiner(".");
            StringJoiner currentEntityPath = new StringJoiner(".");
            LookupsStage currentLookup = queryState.rootLookups;
            for (String path : StringUtils.splitOmitEmptyStrings((CharSequence)join, (char)'.')) {
                Association association;
                rootPath.add(path);
                currentEntityPath.add(path);
                String thisPath = currentEntityPath.toString();
                if (currentLookup.subLookups.containsKey(thisPath)) {
                    currentLookup = currentLookup.subLookups.get(path);
                    currentEntityPath = new StringJoiner(".");
                    continue;
                }
                io.micronaut.data.model.PersistentPropertyPath propertyPath = currentLookup.persistentEntity.getPropertyPath(thisPath);
                PersistentProperty property = propertyPath.getProperty();
                if (!(property instanceof Association) || (association = (Association)property).getKind() == Relation.Kind.EMBEDDED) continue;
                LookupsStage lookupStage = new LookupsStage(association.getAssociatedEntity());
                List<Map<String, Object>> pipeline = currentLookup.pipeline;
                Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
                PersistentEntity persistentEntity = association.getOwner();
                String joinedCollectionName = association.getAssociatedEntity().getPersistedName();
                String ownerCollectionName = persistentEntity.getPersistedName();
                if (association.getKind() == Relation.Kind.MANY_TO_MANY || association.isForeignKey() && !inverseSide.isPresent()) {
                    PersistentEntity associatedEntity = association.getAssociatedEntity();
                    PersistentEntity associationOwner = association.getOwner();
                    PersistentProperty identity = associatedEntity.getIdentity();
                    if (identity == null) {
                        throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
                    }
                    PersistentProperty associatedId = associationOwner.getIdentity();
                    if (associatedId == null) {
                        throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
                    }
                    owningAssociation = inverseSide.orElse(association);
                    boolean isAssociationOwner = !association.getInverseSide().isPresent();
                    NamingStrategy namingStrategy = associationOwner.getNamingStrategy();
                    AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
                    List<String> ownerJoinFields = this.resolveJoinTableAssociatedFields(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
                    List<String> ownerJoinCollectionFields = this.resolveJoinTableJoinFields(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
                    List<String> associationJoinFields = this.resolveJoinTableAssociatedFields(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
                    List<String> associationJoinCollectionFields = this.resolveJoinTableJoinFields(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
                    String joinCollectionName = namingStrategy.mappedName(owningAssociation);
                    ArrayList<Map<String, Object>> joinCollectionLookupPipeline = new ArrayList<Map<String, Object>>();
                    pipeline.add(this.lookup(joinCollectionName, MONGO_ID_FIELD, ownerCollectionName, joinCollectionLookupPipeline, thisPath));
                    joinCollectionLookupPipeline.add(this.lookup(joinedCollectionName, joinedCollectionName, MONGO_ID_FIELD, lookupStage.pipeline, joinedCollectionName));
                    joinCollectionLookupPipeline.add(this.unwind("$" + joinedCollectionName, true));
                    joinCollectionLookupPipeline.add(Map.of("$replaceRoot", Map.of("newRoot", "$" + joinedCollectionName)));
                } else {
                    String currentPath = this.asPath(propertyPath.getAssociations(), propertyPath.getProperty());
                    if (association.isForeignKey()) {
                        String mappedBy = (String)association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElseThrow(IllegalStateException::new);
                        io.micronaut.data.model.PersistentPropertyPath mappedByPath = association.getAssociatedEntity().getPropertyPath(mappedBy);
                        if (mappedByPath == null) {
                            throw new IllegalStateException("Cannot find mapped path: " + mappedBy);
                        }
                        owningAssociation = mappedByPath.getProperty();
                        if (!(owningAssociation instanceof Association)) {
                            throw new IllegalStateException("Expected association as a mapped path: " + mappedBy);
                        }
                        Association associationProperty = owningAssociation;
                        ArrayList<String> localMatchFields = new ArrayList<String>();
                        ArrayList<String> foreignMatchFields = new ArrayList<String>();
                        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)currentLookup.persistentEntity.getIdentity(), (associations, p) -> localMatchFields.add(this.asPath((List<Association>)associations, (PersistentProperty)p)));
                        ArrayList<Association> mappedAssociations = new ArrayList<Association>(mappedByPath.getAssociations());
                        mappedAssociations.add(associationProperty);
                        PersistentEntityUtils.traversePersistentProperties(mappedAssociations, (PersistentProperty)currentLookup.persistentEntity.getIdentity(), (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            foreignMatchFields.add(fieldPath);
                        });
                        pipeline.add(this.lookup(joinedCollectionName, localMatchFields, foreignMatchFields, lookupStage.pipeline, currentPath));
                    } else {
                        ArrayList<Association> mappedAssociations = new ArrayList<Association>(propertyPath.getAssociations());
                        mappedAssociations.add((Association)propertyPath.getProperty());
                        ArrayList<String> localMatchFields = new ArrayList<String>();
                        ArrayList<String> foreignMatchFields = new ArrayList<String>();
                        PersistentProperty identity = lookupStage.persistentEntity.getIdentity();
                        if (identity == null) {
                            throw new IllegalStateException("Null identity of persistent entity: " + lookupStage.persistentEntity);
                        }
                        PersistentEntityUtils.traversePersistentProperties(mappedAssociations, (PersistentProperty)identity, (associations, p) -> localMatchFields.add(this.asPath((List<Association>)associations, (PersistentProperty)p)));
                        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)identity, (associations, p) -> foreignMatchFields.add(this.asPath((List<Association>)associations, (PersistentProperty)p)));
                        pipeline.add(this.lookup(joinedCollectionName, localMatchFields, foreignMatchFields, lookupStage.pipeline, currentPath));
                    }
                    if (association.getKind().isSingleEnded()) {
                        pipeline.add(this.unwind("$" + currentPath, true));
                    }
                }
                currentLookup.subLookups.put(currentEntityPath.toString(), lookupStage);
            }
            queryState.joinPaths.add(join);
        }
    }

    @NonNull
    private List<String> resolveJoinTableJoinFields(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedFields(annotationMetadata, associationOwner, "name");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        ArrayList<String> fields = new ArrayList<String>();
        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)entity.getIdentity(), (associations, property) -> fields.add(this.asPath((List<Association>)associations, (PersistentProperty)property)));
        return fields;
    }

    @NonNull
    private List<String> resolveJoinTableAssociatedFields(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedFields(annotationMetadata, associationOwner, "referencedColumnName");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        ArrayList<String> fields = new ArrayList<String>();
        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)identity, (associations, property) -> fields.add(this.asPath((List<Association>)associations, (PersistentProperty)property)));
        return fields;
    }

    @NonNull
    private List<String> getJoinedFields(AnnotationMetadata annotationMetadata, boolean associationOwner, String columnType) {
        return Collections.emptyList();
    }

    private String asPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return this.getPropertyPersistName(property);
        }
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(this.getPropertyPersistName((PersistentProperty)association));
        }
        joiner.add(this.getPropertyPersistName(property));
        return joiner.toString();
    }

    private Map<String, Object> lookup(String from, String localField, String foreignField, List<Map<String, Object>> pipeline, String as) {
        LinkedHashMap<String, Object> lookup = new LinkedHashMap<String, Object>();
        lookup.put("from", from);
        lookup.put("localField", localField);
        lookup.put("foreignField", foreignField);
        lookup.put("pipeline", pipeline);
        lookup.put("as", as);
        return Map.of("$lookup", lookup);
    }

    private Map<String, Object> lookup(String from, List<String> localFields, List<String> foreignFields, List<Map<String, Object>> pipeline, String as) {
        if (localFields.size() != foreignFields.size()) {
            throw new IllegalStateException("Un-matching join columns size: " + localFields.size() + " != " + foreignFields.size() + " " + localFields + ", " + foreignFields);
        }
        if (localFields.size() == 1) {
            return this.lookup(from, localFields.iterator().next(), foreignFields.iterator().next(), pipeline, as);
        }
        ArrayList<Map<String, List<String>>> matches = new ArrayList<Map<String, List<String>>>(localFields.size());
        LinkedHashMap<String, Object> let = new LinkedHashMap<String, Object>();
        int i = 1;
        Iterator<String> foreignIt = foreignFields.iterator();
        for (String localField : localFields) {
            String var = "v" + i++;
            let.put(var, "$" + localField);
            matches.add(Map.of("$eq", Arrays.asList("$$" + var, "$" + foreignIt.next())));
        }
        Map<String, Object> match = matches.size() > 1 ? Map.of("$match", Map.of("$expr", Map.of("$and", matches))) : Map.of("$match", Map.of("$expr", (Map)matches.iterator().next()));
        return this.lookup(from, let, match, pipeline, as);
    }

    private Map<String, Object> lookup(String from, Map<String, Object> let, Map<String, Object> match, List<Map<String, Object>> pipeline, String as) {
        pipeline.add(match);
        LinkedHashMap<String, Object> lookup = new LinkedHashMap<String, Object>();
        lookup.put("from", from);
        lookup.put("let", let);
        lookup.put("pipeline", pipeline);
        lookup.put("as", as);
        return Map.of("$lookup", lookup);
    }

    private Map<String, Object> unwind(String path, boolean preserveNullAndEmptyArrays) {
        LinkedHashMap<String, Object> unwind = new LinkedHashMap<String, Object>();
        unwind.put("path", path);
        unwind.put("preserveNullAndEmptyArrays", preserveNullAndEmptyArrays);
        return Map.of("$unwind", unwind);
    }

    private boolean isMatchOnlyStage(List<Map<String, Object>> pipeline) {
        return pipeline.size() == 1 && pipeline.iterator().next().containsKey("$match");
    }

    private Map<String, Object> buildWhereClause(Predicate predicate, QueryState queryState) {
        if (predicate == null) {
            return Map.of();
        }
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>();
        if (!(predicate instanceof IPredicate)) {
            throw new IllegalStateException("Unsupported predicate type: " + predicate.getClass().getName());
        }
        IPredicate predicateVisitable = (IPredicate)predicate;
        predicateVisitable.visitPredicate((PredicateVisitor)new MongoPredicateVisitor(queryState, query));
        return query;
    }

    private void buildProjection(Selection<?> selection, Map<String, Object> groupObj, Map<String, Object> projectionObj, Map<String, Object> countObj) {
        if (selection == null) {
            return;
        }
        if (!(selection instanceof ISelection)) {
            throw new IllegalStateException("Unsupported selection type: " + selection.getClass().getName());
        }
        ISelection selectionVisitable = (ISelection)selection;
        selectionVisitable.visitSelection((SelectionVisitor)new MongoSelectionVisitor(projectionObj, groupObj, countObj));
    }

    @NonNull
    private io.micronaut.data.model.PersistentPropertyPath findProperty(QueryState queryState, String name) {
        return this.findPropertyInternal(queryState, queryState.getEntity(), name);
    }

    private io.micronaut.data.model.PersistentPropertyPath findPropertyInternal(QueryState queryState, PersistentEntity entity, String name) {
        io.micronaut.data.model.PersistentPropertyPath propertyPath = entity.getPropertyPath(name);
        if (propertyPath != null) {
            String joinStringPath;
            if (propertyPath.getAssociations().isEmpty()) {
                return propertyPath;
            }
            Association joinAssociation = null;
            StringJoiner joinPathJoiner = new StringJoiner(".");
            for (Association association : propertyPath.getAssociations()) {
                joinPathJoiner.add(association.getName());
                if (association.isEmbedded()) continue;
                if (joinAssociation == null) {
                    joinAssociation = association;
                    continue;
                }
                if (association != joinAssociation.getAssociatedEntity().getIdentity()) {
                    if (!queryState.isAllowJoins()) {
                        throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation");
                    }
                    String joinStringPath2 = joinPathJoiner.toString();
                    if (!queryState.isJoined(joinStringPath2)) {
                        throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath2);
                    }
                    joinAssociation = association;
                    continue;
                }
                joinAssociation = null;
            }
            PersistentProperty property = propertyPath.getProperty();
            if (joinAssociation != null && property != joinAssociation.getAssociatedEntity().getIdentity() && !queryState.isJoined(joinStringPath = joinPathJoiner.toString())) {
                throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath);
            }
        } else if ("id".equals(name) && entity.getIdentity() != null) {
            return io.micronaut.data.model.PersistentPropertyPath.of(Collections.emptyList(), (PersistentProperty)entity.getIdentity(), (String)entity.getIdentity().getName());
        }
        if (propertyPath == null) {
            throw new IllegalArgumentException("Cannot order on non-existent property path: " + name);
        }
        return propertyPath;
    }

    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryBuilder2.UpdateQueryDefinition updateQueryDefinition) {
        final QueryState queryState = new QueryState((QueryBuilder2.BaseQueryDefinition)updateQueryDefinition, true);
        Predicate predicate = updateQueryDefinition.predicate();
        final String predicateQuery = predicate != null ? this.toJsonString(this.buildWhereClause(predicate, queryState)) : "";
        Map propertiesToUpdate = updateQueryDefinition.propertiesToUpdate();
        LinkedHashMap sets = CollectionUtils.newLinkedHashMap((int)propertiesToUpdate.size());
        for (Map.Entry e : propertiesToUpdate.entrySet()) {
            io.micronaut.data.model.PersistentPropertyPath propertyPath = this.findProperty(queryState, (String)e.getKey());
            String propertyPersistName = this.getPropertyPersistName(propertyPath);
            Object v = e.getValue();
            if (v instanceof BindingParameter) {
                BindingParameter bindingParameter = (BindingParameter)v;
                int index = queryState.pushParameter(bindingParameter, this.newBindingContext(propertyPath));
                sets.put(propertyPersistName, Map.of(QUERY_PARAMETER_PLACEHOLDER, index));
                continue;
            }
            sets.put(propertyPersistName, e.getValue());
        }
        final String update = this.toJsonString(Map.of("$set", sets));
        return new QueryResult(){

            @NonNull
            public String getQuery() {
                return predicateQuery;
            }

            public String getUpdate() {
                return update;
            }

            public List<String> getQueryParts() {
                return Collections.emptyList();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryState.getParameterBindings();
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return Collections.emptyMap();
            }
        };
    }

    public QueryResult buildDelete(AnnotationMetadata annotationMetadata, QueryBuilder2.DeleteQueryDefinition queryDefinition) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)queryDefinition);
        QueryState queryState = new QueryState((QueryBuilder2.BaseQueryDefinition)queryDefinition, true);
        Predicate predicate = queryDefinition.predicate();
        String predicateQuery = "";
        if (predicate != null) {
            predicateQuery = this.toJsonString(this.buildWhereClause(predicate, queryState));
        }
        return QueryResult.of((String)predicateQuery, Collections.emptyList(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters(), (int)queryDefinition.limit(), (long)queryDefinition.offset());
    }

    public QueryResult buildPagination(Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    private String toJsonString(Object obj) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, obj);
        return sb.toString();
    }

    private void appendMap(StringBuilder sb, Map<String, Object> map) {
        sb.append("{");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> e = iterator.next();
            String key = e.getKey();
            Object value = e.getValue();
            if (this.skipValue(value)) continue;
            if (this.shouldEscapeKey(key)) {
                sb.append("'").append(key).append("'");
            } else {
                sb.append(key);
            }
            sb.append(":");
            this.append(sb, value);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
    }

    private boolean skipValue(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.isEmpty();
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return collection.isEmpty();
        }
        return false;
    }

    private void appendArray(StringBuilder sb, Collection<?> collection) {
        sb.append("[");
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.append(sb, value);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
    }

    private void append(StringBuilder sb, Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            this.appendMap(sb, map);
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            this.appendArray(sb, collection);
        } else if (obj instanceof RawJsonValue) {
            RawJsonValue rawJsonValue = (RawJsonValue)obj;
            sb.append(rawJsonValue.value);
        } else if (obj == null) {
            sb.append("null");
        } else if (obj instanceof Boolean) {
            sb.append(obj.toString().toLowerCase(Locale.ROOT));
        } else if (obj instanceof Number) {
            sb.append(obj);
        } else {
            sb.append('\'').append(obj).append('\'');
        }
    }

    private boolean shouldEscapeKey(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '$' || c == '_') continue;
            return true;
        }
        return false;
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable io.micronaut.data.model.PersistentPropertyPath ref) {
        return this.newBindingContext(ref, ref);
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable io.micronaut.data.model.PersistentPropertyPath in, @Nullable io.micronaut.data.model.PersistentPropertyPath out) {
        return BindingParameter.BindingContext.create().incomingMethodParameterProperty(in).outgoingQueryParameterProperty(out);
    }

    private String getPropertyPersistName(io.micronaut.data.model.PersistentPropertyPath propertyPath) {
        PersistentProperty property = propertyPath.getProperty();
        if (property.getOwner().getIdentity() == property) {
            return MONGO_ID_FIELD;
        }
        return property.getAnnotationMetadata().stringValue(SerdeConfig.class, "property").orElseGet(() -> ((io.micronaut.data.model.PersistentPropertyPath)propertyPath).getPath());
    }

    private String getPropertyPersistName(PersistentProperty property) {
        if (property.getOwner().getIdentity() == property) {
            return MONGO_ID_FIELD;
        }
        return property.getAnnotationMetadata().stringValue(SerdeConfig.class, "property").orElseGet(() -> ((PersistentProperty)property).getName());
    }

    private Object asLiteral(@Nullable Object value) {
        if (value instanceof RegexPattern) {
            RegexPattern regexPattern = (RegexPattern)value;
            return "'" + Pattern.quote(regexPattern.value) + "'";
        }
        return value;
    }

    @Internal
    private static final class QueryState
    implements PropertyParameterCreator {
        private final Set<String> joinPaths = new TreeSet<String>();
        private final AtomicInteger position = new AtomicInteger(0);
        private final Map<String, String> additionalRequiredParameters = new LinkedHashMap<String, String>();
        private final List<QueryParameterBinding> parameterBindings;
        private final boolean allowJoins;
        private final PersistentEntity entity;
        private final LookupsStage rootLookups;

        private QueryState(QueryBuilder2.BaseQueryDefinition baseQueryDefinition, boolean allowJoins) {
            this.allowJoins = allowJoins;
            this.entity = baseQueryDefinition.persistentEntity();
            this.parameterBindings = new ArrayList<QueryParameterBinding>(this.entity.getPersistentPropertyNames().size());
            this.rootLookups = new LookupsStage(this.entity);
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public boolean isAllowJoins() {
            return this.allowJoins;
        }

        public boolean isJoined(String associationPath) {
            for (String joinPath : this.joinPaths) {
                if (!joinPath.startsWith(associationPath)) continue;
                return true;
            }
            return this.joinPaths.contains(associationPath);
        }

        @NonNull
        public Map<String, String> getAdditionalRequiredParameters() {
            return this.additionalRequiredParameters;
        }

        public List<QueryParameterBinding> getParameterBindings() {
            return this.parameterBindings;
        }

        @Override
        public int pushParameter(@NonNull BindingParameter bindingParameter, @NonNull BindingParameter.BindingContext bindingContext) {
            int index = this.position.getAndIncrement();
            bindingContext = bindingContext.index(index);
            this.parameterBindings.add(bindingParameter.bind(bindingContext));
            return index;
        }
    }

    private static final class LookupsStage {
        private final PersistentEntity persistentEntity;
        private final List<Map<String, Object>> pipeline = new ArrayList<Map<String, Object>>();
        private final Map<String, LookupsStage> subLookups = new HashMap<String, LookupsStage>();

        private LookupsStage(PersistentEntity persistentEntity) {
            this.persistentEntity = persistentEntity;
        }
    }

    private record RawJsonValue(String value) {
    }

    private class MongoPredicateVisitor
    implements AdvancedPredicateVisitor<io.micronaut.data.model.PersistentPropertyPath> {
        private final PersistentEntity persistentEntity;
        private final QueryState queryState;
        private Map<String, Object> query;

        public MongoPredicateVisitor(QueryState queryState, Map<String, Object> query) {
            this.queryState = queryState;
            this.query = query;
            this.persistentEntity = queryState.getEntity();
        }

        private void appendOperatorExpression(io.micronaut.data.model.PersistentPropertyPath propertyPath, String op, Object value) {
            if (value instanceof PersistentPropertyPath) {
                PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)value;
                io.micronaut.data.model.PersistentPropertyPath p2 = this.getRequiredProperty((PersistentPropertyPath<?>)persistentPropertyPath);
                this.query.put("$expr", Map.of(op, Arrays.asList("$" + propertyPath.getPath(), "$" + p2.getPath())));
                return;
            }
            PersistentEntityUtils.traversePersistentProperties((io.micronaut.data.model.PersistentPropertyPath)propertyPath, (associations, property) -> {
                String path = MongoQueryBuilder2.this.asPath((List<Association>)associations, (PersistentProperty)property);
                this.query.put(path, Collections.singletonMap(op, this.valueRepresentation(this.queryState, propertyPath, io.micronaut.data.model.PersistentPropertyPath.of((List)associations, (PersistentProperty)property), value)));
            });
        }

        private void visitPredicate(IExpression<Boolean> expression) {
            if (expression instanceof IPredicate) {
                IPredicate predicateVisitable = (IPredicate)expression;
                predicateVisitable.visitPredicate((PredicateVisitor)this);
            } else if (expression instanceof PersistentPropertyPath) {
                PersistentPropertyPath propertyPath = (PersistentPropertyPath)expression;
                this.visitIsTrue(this.getRequiredProperty((PersistentPropertyPath<?>)propertyPath));
            } else {
                throw new IllegalStateException("Unknown boolean expression: " + expression);
            }
        }

        public void visit(ConjunctionPredicate conjunction) {
            Collection predicates = conjunction.getPredicates();
            if (predicates.isEmpty()) {
                return;
            }
            if (predicates.size() == 1) {
                this.visitPredicate((IExpression<Boolean>)((IExpression)predicates.iterator().next()));
                return;
            }
            ArrayList<Object> ops = new ArrayList<Object>(predicates.size());
            this.query.put("$and", ops);
            this.visitConjunctionPredicate(predicates, ops);
        }

        private void visitConjunctionPredicate(Collection<? extends IExpression<Boolean>> predicates, List<Object> ops) {
            for (IExpression<Boolean> iExpression : predicates) {
                if (iExpression instanceof ConjunctionPredicate) {
                    ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)iExpression;
                    this.visitConjunctionPredicate(conjunctionPredicate.getPredicates(), ops);
                    continue;
                }
                Map<String, Object> preQuery = this.query;
                this.query = new LinkedHashMap<String, Object>();
                ops.add(this.query);
                this.visitPredicate(iExpression);
                this.query = preQuery;
            }
        }

        public void visit(DisjunctionPredicate disjunction) {
            Collection predicates = disjunction.getPredicates();
            if (predicates.isEmpty()) {
                return;
            }
            if (predicates.size() == 1) {
                this.visitPredicate((IExpression<Boolean>)((IExpression)predicates.iterator().next()));
                return;
            }
            ArrayList<Object> ops = new ArrayList<Object>(predicates.size());
            this.query.put("$or", ops);
            this.visitDisjunctionPredicate(predicates, ops);
        }

        private void visitDisjunctionPredicate(Collection<? extends IExpression<Boolean>> predicates, List<Object> ops) {
            for (IExpression<Boolean> iExpression : predicates) {
                Map<String, Object> preQuery = this.query;
                this.query = new LinkedHashMap<String, Object>();
                ops.add(this.query);
                if (iExpression instanceof DisjunctionPredicate) {
                    DisjunctionPredicate disjunctionPredicate = (DisjunctionPredicate)iExpression;
                    this.visitDisjunctionPredicate(disjunctionPredicate.getPredicates(), ops);
                } else {
                    this.visitPredicate(iExpression);
                }
                this.query = preQuery;
            }
        }

        public void visit(NegatedPredicate negate) {
            IExpression negated = negate.getNegated();
            if (negated instanceof PersistentPropertyInPredicate) {
                PersistentPropertyInPredicate p = (PersistentPropertyInPredicate)negated;
                this.visitIn(this.getRequiredProperty((PersistentPropertyPath<?>)p.getPropertyPath()), p.getValues(), true);
                return;
            }
            Map<String, Object> preQuery = this.query;
            this.query = new LinkedHashMap<String, Object>();
            this.visitPredicate((IExpression<Boolean>)negate.getNegated());
            if (this.query.size() != 1) {
                throw new IllegalStateException("Expected size of 1: Got: " + this.query + " " + negate.getNegated());
            }
            Map.Entry<String, Object> propertyPredicate = this.query.entrySet().iterator().next();
            Map<String, Object> negatedPropertyPredicate = Map.of(MongoQueryBuilder2.NOT, propertyPredicate.getValue());
            this.query = preQuery;
            this.query.put(propertyPredicate.getKey(), negatedPropertyPredicate);
        }

        public io.micronaut.data.model.PersistentPropertyPath getRequiredProperty(PersistentPropertyPath<?> persistentPropertyPath) {
            return persistentPropertyPath.getPropertyPath();
        }

        public void visitIn(io.micronaut.data.model.PersistentPropertyPath propertyPath, Collection<?> values, boolean negated) {
            this.query.put(MongoQueryBuilder2.this.getPropertyPersistName(propertyPath), Map.of(negated ? "$nin" : "$in", values.stream().map(val -> this.valueRepresentation(this.queryState, propertyPath, val)).toList()));
        }

        public void visitRegexp(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression) {
            Object value = expression;
            if (expression instanceof LiteralExpression) {
                LiteralExpression literalExpression = (LiteralExpression)expression;
                value = new RegexPattern((String)literalExpression.getValue());
            }
            this.appendOperatorExpression(leftProperty, MongoQueryBuilder2.REGEX, value);
        }

        public void visitContains(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression, boolean ignoreCase) {
            this.handleRegexPropertyExpression(leftProperty, ignoreCase, false, false, false, expression);
        }

        public void visitEndsWith(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression, boolean ignoreCase) {
            this.handleRegexPropertyExpression(leftProperty, ignoreCase, false, false, true, expression);
        }

        public void visitStartsWith(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression, boolean ignoreCase) {
            this.handleRegexPropertyExpression(leftProperty, ignoreCase, false, true, false, expression);
        }

        public void visit(LikePredicate likePredicate) {
            if (likePredicate.isCaseInsensitive()) {
                throw new UnsupportedOperationException("ILike is not supported by this implementation.");
            }
            this.handleRegexPropertyExpression(CriteriaUtils.requireProperty((Expression)likePredicate.getExpression()).getPropertyPath(), false, false, false, false, likePredicate.getPattern());
        }

        public void visitEquals(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression, boolean ignoreCase) {
            if (ignoreCase) {
                this.handleRegexPropertyExpression(leftProperty, true, false, true, true, expression);
                return;
            }
            this.appendPropertyEquals(leftProperty, expression);
        }

        private void appendPropertyEquals(io.micronaut.data.model.PersistentPropertyPath leftProperty, Object value) {
            this.appendOperatorExpression(leftProperty, "$eq", value);
        }

        public void visitNotEquals(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression, boolean ignoreCase) {
            if (ignoreCase) {
                this.handleRegexPropertyExpression(leftProperty, true, true, true, true, expression);
                return;
            }
            this.appendPropertyNotEquals(leftProperty, expression);
        }

        private void appendPropertyNotEquals(io.micronaut.data.model.PersistentPropertyPath leftProperty, Object value) {
            this.appendOperatorExpression(leftProperty, "$ne", value);
        }

        public void visitGreaterThan(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression) {
            this.appendOperatorExpression(leftProperty, "$gt", expression);
        }

        public void visitGreaterThanOrEquals(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression) {
            this.appendOperatorExpression(leftProperty, "$gte", expression);
        }

        public void visitLessThan(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression) {
            this.appendOperatorExpression(leftProperty, "$lt", expression);
        }

        public void visitLessThanOrEquals(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression) {
            this.appendOperatorExpression(leftProperty, "$lte", expression);
        }

        public void visitInBetween(io.micronaut.data.model.PersistentPropertyPath property, Expression<?> from, Expression<?> to) {
            String propertyName = MongoQueryBuilder2.this.getPropertyPersistName(property);
            this.query.put("$and", Arrays.asList(Map.of(propertyName, Map.of("$gte", this.valueRepresentation(this.queryState, property, from))), Map.of(propertyName, Map.of("$lte", this.valueRepresentation(this.queryState, property, to)))));
        }

        public void visitIsFalse(io.micronaut.data.model.PersistentPropertyPath property) {
            this.appendPropertyEquals(property, false);
        }

        public void visitIsNotNull(io.micronaut.data.model.PersistentPropertyPath property) {
            this.appendPropertyNotEquals(property, null);
        }

        public void visitIsNull(io.micronaut.data.model.PersistentPropertyPath property) {
            this.appendPropertyEquals(property, null);
        }

        public void visitIsTrue(io.micronaut.data.model.PersistentPropertyPath property) {
            this.appendPropertyEquals(property, true);
        }

        public void visitIsEmpty(io.micronaut.data.model.PersistentPropertyPath property) {
            String propertyName = MongoQueryBuilder2.this.getPropertyPersistName(property);
            this.query.put("$or", Arrays.asList(Map.of(propertyName, Map.of("$eq", "")), Map.of(propertyName, Map.of("$exists", false))));
        }

        public void visitIsNotEmpty(io.micronaut.data.model.PersistentPropertyPath property) {
            String propertyName = MongoQueryBuilder2.this.getPropertyPersistName(property);
            this.query.put("$and", Arrays.asList(Map.of(propertyName, Map.of("$ne", "")), Map.of(propertyName, Map.of("$exists", true))));
        }

        public void visitArrayContains(io.micronaut.data.model.PersistentPropertyPath leftProperty, Expression<?> expression) {
            List<Object> criteriaValue;
            Object value = expression;
            if (expression instanceof LiteralExpression) {
                LiteralExpression literalExpression = (LiteralExpression)expression;
                value = literalExpression.getValue();
            }
            if (value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                List values = CollectionUtils.iterableToList((Iterable)iterable);
                criteriaValue = values.stream().map(val -> this.valueRepresentation(this.queryState, leftProperty, val)).toList();
            } else {
                criteriaValue = List.of(this.valueRepresentation(this.queryState, leftProperty, value));
            }
            this.query.put(MongoQueryBuilder2.this.getPropertyPersistName(leftProperty), Map.of("$all", criteriaValue));
        }

        public void visitIdEquals(Expression<?> expression) {
            if (this.persistentEntity.hasCompositeIdentity()) {
                throw new IllegalStateException("Composite ID not supported!");
            }
            if (!this.persistentEntity.hasIdentity()) {
                throw new IllegalStateException("No ID found for entity: " + this.persistentEntity.getName());
            }
            this.query.put(MongoQueryBuilder2.MONGO_ID_FIELD, this.valueRepresentation(this.queryState, new io.micronaut.data.model.PersistentPropertyPath(List.of(), this.persistentEntity.getIdentity()), expression));
        }

        private void handleRegexPropertyExpression(io.micronaut.data.model.PersistentPropertyPath propertyPath, boolean ignoreCase, boolean negate, boolean startsWith, boolean endsWith, Object value) {
            Object regexValue;
            LinkedHashMap<String, String> regexCriteria = new LinkedHashMap<String, String>(2);
            regexCriteria.put(MongoQueryBuilder2.OPTIONS, ignoreCase ? "i" : "");
            if (value instanceof BindingParameter) {
                BindingParameter bindingParameter = (BindingParameter)value;
                int index = this.queryState.pushParameter(bindingParameter, MongoQueryBuilder2.this.newBindingContext(propertyPath, propertyPath));
                regexValue = "$mn_qp:" + index;
            } else {
                regexValue = value.toString();
            }
            StringBuilder regexValueBuff = new StringBuilder();
            if (startsWith) {
                regexValueBuff.append("^");
            }
            regexValueBuff.append((String)regexValue);
            if (endsWith) {
                regexValueBuff.append("$");
            }
            regexCriteria.put(MongoQueryBuilder2.REGEX, regexValueBuff.toString());
            Map<String, Object> filterValue = negate ? Map.of(MongoQueryBuilder2.NOT, regexCriteria) : regexCriteria;
            this.query.put(MongoQueryBuilder2.this.getPropertyPersistName(propertyPath), filterValue);
        }

        private Object valueRepresentation(PropertyParameterCreator parameterCreator, io.micronaut.data.model.PersistentPropertyPath propertyPath, Object value) {
            return this.valueRepresentation(parameterCreator, propertyPath, propertyPath, value);
        }

        private Object valueRepresentation(PropertyParameterCreator parameterCreator, io.micronaut.data.model.PersistentPropertyPath inPropertyPath, io.micronaut.data.model.PersistentPropertyPath outPropertyPath, Object value) {
            if (value instanceof LocalDate) {
                LocalDate localDate = (LocalDate)value;
                return Map.of(MongoQueryBuilder2.MONGO_DATE_IDENTIFIER, this.formatDate(localDate));
            }
            if (value instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)value;
                return Map.of(MongoQueryBuilder2.MONGO_DATE_IDENTIFIER, this.formatDate(localDateTime));
            }
            if (value instanceof BindingParameter) {
                BindingParameter bindingParameter = (BindingParameter)value;
                int index = parameterCreator.pushParameter(bindingParameter, MongoQueryBuilder2.this.newBindingContext(inPropertyPath, outPropertyPath));
                return Map.of(MongoQueryBuilder2.QUERY_PARAMETER_PLACEHOLDER, index);
            }
            return MongoQueryBuilder2.this.asLiteral(value);
        }

        private String formatDate(LocalDate localDate) {
            return this.formatDate(localDate.atStartOfDay());
        }

        private String formatDate(LocalDateTime localDateTime) {
            return this.formatDate(localDateTime.atZone(ZoneId.of("Z")).toInstant().toEpochMilli());
        }

        private String formatDate(long dateTime) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(dateTime), ZoneId.of("Z")).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
    }

    private final class MongoSelectionVisitor
    implements SelectionVisitor {
        private final Map<String, Object> projectionObj;
        private final Map<String, Object> groupObj;
        private final Map<String, Object> countObj;
        private String alias;

        public MongoSelectionVisitor(Map<String, Object> projectionObj, Map<String, Object> groupObj, Map<String, Object> countObj) {
            this.projectionObj = projectionObj;
            this.groupObj = groupObj;
            this.countObj = countObj;
        }

        public void visit(PersistentPropertyPath<?> persistentPropertyPath) {
            PersistentProperty property = persistentPropertyPath.getProperty();
            String propertyPersistName = MongoQueryBuilder2.this.getPropertyPersistName(property);
            this.projectionObj.put(propertyPersistName, 1);
        }

        public void visit(AliasedSelection<?> aliasedSelection) {
            this.alias = aliasedSelection.getAlias();
            aliasedSelection.getSelection().visitSelection((SelectionVisitor)this);
            this.alias = null;
        }

        public void visit(PersistentEntityRoot<?> entityRoot) {
        }

        public void visit(CompoundSelection<?> compoundSelection) {
            for (Selection selection : compoundSelection.getCompoundSelectionItems()) {
                if (selection instanceof ISelection) {
                    ISelection selectionVisitable = (ISelection)selection;
                    selectionVisitable.visitSelection((SelectionVisitor)this);
                    continue;
                }
                throw new IllegalStateException("Unknown selection object: " + selection);
            }
        }

        public void visit(LiteralExpression<?> literalExpression) {
            this.projectionObj.put("val", Map.of("$literal", MongoQueryBuilder2.this.asLiteral(literalExpression.getValue())));
        }

        public void visit(UnaryExpression<?> unaryExpression) {
            Expression expression = unaryExpression.getExpression();
            block0 : switch (unaryExpression.getType()) {
                case SUM: 
                case AVG: 
                case MAX: 
                case MIN: {
                    io.micronaut.data.model.PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty((Expression)expression).getPropertyPath();
                    switch (unaryExpression.getType()) {
                        case SUM: {
                            this.addProjection(this.groupObj, "$sum", propertyPath);
                            break block0;
                        }
                        case AVG: {
                            this.addProjection(this.groupObj, "$avg", propertyPath);
                            break block0;
                        }
                        case MAX: {
                            this.addProjection(this.groupObj, "$max", propertyPath);
                            break block0;
                        }
                        case MIN: {
                            this.addProjection(this.groupObj, "$min", propertyPath);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unsupported expression type: " + unaryExpression.getExpression());
                }
                case COUNT: {
                    this.countObj.put("$count", "result");
                    break;
                }
                case COUNT_DISTINCT: {
                    if (expression instanceof PersistentEntityRoot) {
                        this.countObj.put("$count", "result");
                        break;
                    }
                    if (expression instanceof PersistentPropertyPath) {
                        throw new UnsupportedOperationException("Count distinct against property is not supported by Micronaut Data MongoDB.");
                    }
                    throw new IllegalStateException("Illegal expression: " + expression + " for count distinct selection!");
                }
                default: {
                    throw new IllegalStateException("Unsupported expression type: " + unaryExpression.getExpression());
                }
            }
        }

        public void visit(IdExpression<?, ?> idExpression) {
            this.projectionObj.put(MongoQueryBuilder2.MONGO_ID_FIELD, 1);
        }

        private void addProjection(Map<String, Object> groupBy, String op, io.micronaut.data.model.PersistentPropertyPath propertyPath) {
            groupBy.put(this.alias == null ? propertyPath.getProperty().getName() : this.alias, Map.of(op, "$" + propertyPath.getPath()));
        }

        public void visit(FunctionExpression<?> functionExpression) {
            throw new UnsupportedOperationException("Function expression is not supported by Micronaut Data MongoDB.");
        }

        public void visit(BinaryExpression<?> binaryExpression) {
            throw new UnsupportedOperationException("Binary expression: " + binaryExpression + " is not supported by Micronaut Data MongoDB.");
        }
    }

    private record RegexPattern(String value) {
    }

    private static interface PropertyParameterCreator {
        public int pushParameter(@NonNull BindingParameter var1, @NonNull BindingParameter.BindingContext var2);
    }
}

