/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.reactive;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.exceptions.NoConnectionException;
import io.micronaut.data.connection.reactive.ReactiveStreamsConnectionOperations;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public interface ReactorConnectionOperations<C>
extends ReactiveStreamsConnectionOperations<C> {
    @NonNull
    default public ConnectionStatus<C> getConnectionStatus(@NonNull ContextView contextView) {
        return this.findConnectionStatus(contextView).orElseThrow(NoConnectionException::new);
    }

    public Optional<ConnectionStatus<C>> findConnectionStatus(@NonNull ContextView var1);

    @NonNull
    default public <T> Flux<T> withConnectionFlux(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, Flux<T>> handler) {
        return Flux.from(this.withConnection(definition, handler::apply));
    }

    @NonNull
    default public <T> Flux<T> withConnectionFlux(@NonNull Function<ConnectionStatus<C>, Flux<T>> handler) {
        return this.withConnectionFlux(ConnectionDefinition.DEFAULT, handler);
    }

    @NonNull
    default public <T> Mono<T> withConnectionMono(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, Mono<T>> handler) {
        return Mono.from(this.withConnection(definition, handler::apply));
    }

    default public <T> Mono<T> withConnectionMono(@NonNull Function<ConnectionStatus<C>, Mono<T>> handler) {
        return this.withConnectionMono(ConnectionDefinition.DEFAULT, handler);
    }

    @Override
    @NonNull
    default public <T> Publisher<T> withConnection(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, Publisher<T>> handler) {
        return this.withConnectionFlux(definition, connection -> Flux.from((Publisher)((Publisher)handler.apply((ConnectionStatus)connection))));
    }
}

