/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.jdbc.oracle;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.annotation.ClientInfo;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import io.micronaut.data.connection.jdbc.oracle.OracleClientInfoCondition;
import io.micronaut.data.connection.support.AbstractConnectionOperations;
import io.micronaut.data.connection.support.ConnectionCustomizer;
import io.micronaut.runtime.ApplicationConfiguration;
import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=DataSource.class)
@Requires(condition=OracleClientInfoCondition.class)
@Context
@Internal
final class OracleClientInfoConnectionCustomizer
implements ConnectionCustomizer<Connection> {
    private static final String NAME_MEMBER = "name";
    private static final String VALUE_MEMBER = "value";
    private static final String INTERCEPTED_SUFFIX = "$Intercepted";
    private static final String ORACLE_CLIENT_ID = "OCSID.CLIENTID";
    private static final String ORACLE_MODULE = "OCSID.MODULE";
    private static final String ORACLE_ACTION = "OCSID.ACTION";
    private static final String ORACLE_CLIENT_INFO = "OCSID.CLIENT_INFO";
    private static final String ORACLE_CONNECTION_DATABASE_PRODUCT_NAME = "Oracle";
    private static final Logger LOG = LoggerFactory.getLogger(OracleClientInfoConnectionCustomizer.class);
    private static final Map<Class<?>, String> MODULE_CLASS_MAP = new ConcurrentHashMap(100);
    private static final int MAX_VALUE_LENGTH = 64;
    @Nullable
    private final String applicationName;

    OracleClientInfoConnectionCustomizer(@NonNull DataSource dataSource, @NonNull @Parameter AbstractConnectionOperations<Connection> connectionOperations, @Nullable ApplicationConfiguration applicationConfiguration) {
        this.applicationName = applicationConfiguration != null ? (String)applicationConfiguration.getName().orElse(null) : null;
        try {
            Connection connection = DelegatingDataSource.unwrapDataSource(dataSource).getConnection();
            if (this.isOracleConnection(connection)) {
                connectionOperations.addConnectionCustomizer((ConnectionCustomizer)this);
            }
        }
        catch (SQLException e) {
            LOG.error("Failed to get connection for oracle connection listener", (Throwable)e);
        }
    }

    private static String truncate(String name, String value) {
        if (value.length() > 64) {
            LOG.trace("Truncating client info value '{}' for {} as it is longer than {} chars", new Object[]{value, name, 64});
            return value.substring(0, 64);
        }
        return value;
    }

    private static String preprocessClassName(Class<?> clazz) {
        return NameUtils.getShortenedName((String)clazz.getName().replace(INTERCEPTED_SUFFIX, ""));
    }

    public <R> Function<ConnectionStatus<Connection>, R> intercept(Function<ConnectionStatus<Connection>, R> operation) {
        return connectionStatus -> {
            ConnectionDefinition connectionDefinition = connectionStatus.getDefinition();
            Map<String, String> connectionClientInfo = this.getConnectionClientInfo(connectionDefinition);
            this.applyClientInfo((ConnectionStatus<Connection>)connectionStatus, connectionClientInfo);
            try {
                Object r = operation.apply((ConnectionStatus<Connection>)connectionStatus);
                return r;
            }
            finally {
                this.clearClientInfo((ConnectionStatus<Connection>)connectionStatus, connectionClientInfo);
            }
        };
    }

    private void applyClientInfo(@NonNull ConnectionStatus<Connection> connectionStatus, @NonNull Map<String, String> connectionClientInfo) {
        if (CollectionUtils.isNotEmpty(connectionClientInfo)) {
            Connection connection = (Connection)connectionStatus.getConnection();
            try {
                for (Map.Entry<String, String> additionalInfo : connectionClientInfo.entrySet()) {
                    String name = additionalInfo.getKey();
                    String value = OracleClientInfoConnectionCustomizer.truncate(name, additionalInfo.getValue());
                    connection.setClientInfo(name, value);
                }
            }
            catch (SQLClientInfoException e) {
                LOG.warn("Failed to set connection tracing info: {}", connectionClientInfo, (Object)e);
            }
        }
    }

    private void clearClientInfo(@NonNull ConnectionStatus<Connection> connectionStatus, @NonNull Map<String, String> connectionClientInfo) {
        if (CollectionUtils.isNotEmpty(connectionClientInfo)) {
            try {
                Connection connection = (Connection)connectionStatus.getConnection();
                for (String key : connectionClientInfo.keySet()) {
                    connection.setClientInfo(key, null);
                }
            }
            catch (SQLClientInfoException e) {
                LOG.debug("Failed to clear connection tracing info", (Throwable)e);
            }
        }
    }

    private boolean isOracleConnection(Connection connection) {
        try {
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            return StringUtils.isNotEmpty((CharSequence)databaseProductName) && databaseProductName.equalsIgnoreCase(ORACLE_CONNECTION_DATABASE_PRODUCT_NAME);
        }
        catch (SQLException e) {
            LOG.debug("Failed to get database product name from the connection", (Throwable)e);
            return false;
        }
    }

    @NonNull
    private Map<String, String> getConnectionClientInfo(@NonNull ConnectionDefinition connectionDefinition) {
        AnnotationMetadata annotationMetadata = connectionDefinition.getAnnotationMetadata();
        AnnotationValue annotation = annotationMetadata.getAnnotation(ClientInfo.class);
        List clientInfoValues = annotation != null ? annotation.getAnnotations(VALUE_MEMBER) : Collections.emptyList();
        LinkedHashMap<String, String> clientInfoAttributes = new LinkedHashMap<String, String>(clientInfoValues.size());
        if (CollectionUtils.isNotEmpty((Collection)clientInfoValues)) {
            for (AnnotationValue clientInfoValue : clientInfoValues) {
                String name = (String)clientInfoValue.getRequiredValue(NAME_MEMBER, String.class);
                String value = (String)clientInfoValue.getRequiredValue(VALUE_MEMBER, String.class);
                clientInfoAttributes.put(name, value);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.applicationName)) {
            clientInfoAttributes.putIfAbsent(ORACLE_CLIENT_ID, this.applicationName);
        }
        if (annotationMetadata instanceof MethodInvocationContext) {
            MethodInvocationContext methodInvocationContext = (MethodInvocationContext)annotationMetadata;
            clientInfoAttributes.putIfAbsent(ORACLE_MODULE, MODULE_CLASS_MAP.computeIfAbsent(methodInvocationContext.getTarget().getClass(), OracleClientInfoConnectionCustomizer::preprocessClassName));
            clientInfoAttributes.putIfAbsent(ORACLE_ACTION, methodInvocationContext.getName());
        }
        clientInfoAttributes.putIfAbsent(ORACLE_CLIENT_INFO, Thread.currentThread().getName());
        return clientInfoAttributes;
    }
}

