/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.jdbc.oracle;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;
import io.micronaut.inject.BeanDefinition;

@Internal
final class OracleClientInfoCondition
implements Condition {
    static final String DATASOURCES = "datasources";
    private static final Character DOT = Character.valueOf('.');
    private static final String DIALECT = "dialect";
    private static final String ORACLE_CLIENT_INFO_ENABLED = "enable-oracle-client-info";
    private static final String ORACLE_DIALECT = "ORACLE";

    OracleClientInfoCondition() {
    }

    public boolean matches(ConditionContext context) {
        String dataSourceName;
        AnnotationMetadataProvider annotationMetadataProvider;
        BeanResolutionContext beanResolutionContext = context.getBeanResolutionContext();
        if (beanResolutionContext == null) {
            return true;
        }
        Qualifier currentQualifier = beanResolutionContext.getCurrentQualifier();
        if (currentQualifier == null && (annotationMetadataProvider = context.getComponent()) instanceof BeanDefinition) {
            BeanDefinition definition = (BeanDefinition)annotationMetadataProvider;
            currentQualifier = definition.getDeclaredQualifier();
        }
        if (currentQualifier instanceof Named) {
            Named named = (Named)currentQualifier;
            dataSourceName = named.getName();
        } else {
            dataSourceName = "default";
        }
        String dialectProperty = DATASOURCES + DOT + dataSourceName + DOT + DIALECT;
        String dialect = context.getProperty(dialectProperty, String.class).orElse(null);
        if (!ORACLE_DIALECT.equalsIgnoreCase(dialect)) {
            return false;
        }
        String property = DATASOURCES + DOT + dataSourceName + DOT + ORACLE_CLIENT_INFO_ENABLED;
        return (Boolean)context.getProperty(property, Boolean.class, (Object)false);
    }
}

