/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.connection;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.support.AbstractConnectionOperations;
import io.micronaut.data.hibernate.conf.RequiresSyncHibernate;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;

@Order(value=100)
@Internal
@RequiresSyncHibernate
@EachBean(value=SessionFactory.class)
public final class HibernateConnectionOperations
extends AbstractConnectionOperations<Session> {
    private final SessionFactory sessionFactory;
    @Nullable
    private final Interceptor entityInterceptor;

    public HibernateConnectionOperations(SessionFactory sessionFactory, @Nullable Interceptor entityInterceptor) {
        this.sessionFactory = sessionFactory;
        this.entityInterceptor = entityInterceptor;
    }

    protected Session openConnection(ConnectionDefinition definition) {
        SessionBuilder sessionBuilder = this.sessionFactory.withOptions();
        if (this.entityInterceptor != null) {
            sessionBuilder = sessionBuilder.interceptor(this.entityInterceptor);
        }
        return sessionBuilder.openSession();
    }

    protected void setupConnection(ConnectionStatus<Session> connectionStatus) {
    }

    protected void closeConnection(ConnectionStatus<Session> connectionStatus) {
        ((Session)connectionStatus.getConnection()).close();
    }
}

