/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.chatbots.telegram.azurefunction;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.annotation.AuthorizationLevel;
import com.microsoft.azure.functions.annotation.FunctionName;
import com.microsoft.azure.functions.annotation.HttpTrigger;
import io.micronaut.azure.function.AzureFunction;
import io.micronaut.chatbots.core.BotConfiguration;
import io.micronaut.chatbots.core.Dispatcher;
import io.micronaut.chatbots.telegram.api.Update;
import io.micronaut.chatbots.telegram.api.send.Send;
import io.micronaut.chatbots.telegram.core.TelegramBotConfiguration;
import io.micronaut.chatbots.telegram.core.TokenValidator;
import jakarta.inject.Inject;
import java.util.Optional;

public class Handler
extends AzureFunction {
    @Inject
    TokenValidator tokenValidator;
    @Inject
    Dispatcher<TelegramBotConfiguration, Update, Send> dispatcher;

    @FunctionName(value="TelegramTrigger")
    public HttpResponseMessage handle(@HttpTrigger(name="req", methods={HttpMethod.POST}, route="{*route}", authLevel=AuthorizationLevel.ANONYMOUS) HttpRequestMessage<Update> request, ExecutionContext context) {
        this.info("Executing Function: " + ((Object)((Object)this)).getClass().getName(), context);
        if (!request.getHeaders().containsKey("X-Telegram-Bot-Api-Secret-Token")) {
            this.info("Token not found in header X-Telegram-Bot-Api-Secret-Token", context);
            return request.createResponseBuilder(HttpStatus.UNAUTHORIZED).build();
        }
        String token = (String)request.getHeaders().get("X-Telegram-Bot-Api-Secret-Token");
        Optional botOptional = this.tokenValidator.validate(token);
        if (!botOptional.isPresent()) {
            this.info("BotConfiguration not found for header X-Telegram-Bot-Api-Secret-Token", context);
            return request.createResponseBuilder(HttpStatus.UNAUTHORIZED).build();
        }
        TelegramBotConfiguration bot = (TelegramBotConfiguration)botOptional.get();
        return this.dispatcher.dispatch((BotConfiguration)bot, (Object)((Update)request.getBody())).map(rsp -> request.createResponseBuilder(HttpStatus.OK).body(rsp).build()).orElseGet(() -> request.createResponseBuilder(HttpStatus.OK).build());
    }

    private void info(String message, ExecutionContext context) {
        if (context != null) {
            context.getLogger().info(message);
        }
    }
}

