/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.handler;

import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.Observation;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;

public class TracingAwareMeterObservationHandler<T extends Observation.Context>
implements MeterObservationHandler<T> {
    private final MeterObservationHandler<T> delegate;
    private final Tracer tracer;

    public TracingAwareMeterObservationHandler(MeterObservationHandler<T> delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    public void onStart(T context) {
        this.delegate.onStart(context);
    }

    public void onError(T context) {
        this.delegate.onError(context);
    }

    public void onEvent(Observation.Event event, T context) {
        this.delegate.onEvent(event, context);
    }

    public void onScopeOpened(T context) {
        this.delegate.onScopeOpened(context);
    }

    public void onScopeClosed(T context) {
        this.delegate.onScopeClosed(context);
    }

    public void onStop(T context) {
        TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)context.getRequired(TracingObservationHandler.TracingContext.class);
        Span currentSpan = tracingContext.getSpan();
        if (currentSpan != null) {
            try (CurrentTraceContext.Scope ignored = this.tracer.currentTraceContext().maybeScope(currentSpan.context());){
                this.delegate.onStop(context);
            }
        } else {
            this.delegate.onStop(context);
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return this.delegate.supportsContext(context);
    }
}

