/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.Link;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.test.simple.SimpleSpan;
import io.micrometer.tracing.test.simple.SimpleTraceContext;
import io.micrometer.tracing.test.simple.SimpleTracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

public class SimpleSpanBuilder
implements Span.Builder {
    private List<String> events = new ArrayList<String>();
    private Map<String, String> tags = new HashMap<String, String>();
    private List<Link> links = new ArrayList<Link>();
    private @Nullable Throwable throwable;
    private @Nullable String remoteServiceName;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Span.Kind spanKind;
    private @Nullable String name;
    private @Nullable String ip;
    private int port;
    private SimpleTracer simpleTracer;
    private long startTimestamp;
    private @Nullable TimeUnit startTimestampUnit;
    private @Nullable TraceContext parentContext;

    public SimpleSpanBuilder(SimpleTracer simpleTracer) {
        this.simpleTracer = simpleTracer;
    }

    public Span.Builder setParent(TraceContext context) {
        this.parentContext = context;
        return this;
    }

    public Span.Builder setNoParent() {
        this.parentContext = null;
        return this;
    }

    public Span.Builder name(String name) {
        this.name = name;
        return this;
    }

    public Span.Builder event(String value) {
        this.events.add(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public Span.Builder kind(Span.Kind spanKind) {
        this.spanKind = spanKind;
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
        return this;
    }

    public Span.Builder remoteIpAndPort(String ip, int port) {
        this.ip = ip;
        this.port = port;
        return this;
    }

    public Span.Builder startTimestamp(long startTimestamp, TimeUnit unit) {
        this.startTimestamp = startTimestamp;
        this.startTimestampUnit = unit;
        return this;
    }

    public Span.Builder addLink(Link link) {
        this.links.add(new Link(link.getTraceContext(), link.getTags()));
        return this;
    }

    public Span start() {
        SimpleSpan span = new SimpleSpan();
        this.getTags().forEach(span::tag);
        this.getEvents().forEach(span::event);
        this.setMaybeNullFields(span);
        span.addLinks((List)this.links);
        if (this.parentContext != null) {
            SimpleTraceContext ctx = span.context();
            ctx.setSpanId(ctx.generateId());
            ctx.setParentId(this.parentContext.spanId());
            ctx.setTraceId(this.parentContext.traceId());
            ctx.setSampled(this.parentContext.sampled());
        }
        span.start();
        if (this.startTimestampUnit != null) {
            span.setStartMillis(this.startTimestampUnit.toMillis(this.startTimestamp));
        }
        this.simpleTracer.getSpans().add(span);
        return span;
    }

    private void setMaybeNullFields(SimpleSpan span) {
        span.remoteServiceName(this.getRemoteServiceName());
        span.error(this.getThrowable());
        span.setSpanKind(this.getSpanKind());
        span.name(this.getName());
        span.remoteIpAndPort(this.getIp(), this.getPort());
    }

    public List<String> getEvents() {
        return this.events;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public @Nullable Throwable getThrowable() {
        return this.throwable;
    }

    public @Nullable String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Span.Kind getSpanKind() {
        return this.spanKind;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public SimpleTracer getSimpleTracer() {
        return this.simpleTracer;
    }

    public List<Link> getLinks() {
        return this.links;
    }
}

