/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanAndScope;
import io.micrometer.tracing.Tracer;
import java.util.Deque;

public class SimpleSpanInScope
implements Tracer.SpanInScope {
    private volatile boolean closed;
    private final Deque<SpanAndScope> scopedSpans;
    private final Span span;
    private final SpanAndScope spanAndScope;

    public SimpleSpanInScope(Span span, Deque<SpanAndScope> scopedSpans) {
        this.span = span;
        this.scopedSpans = scopedSpans;
        this.spanAndScope = new SpanAndScope(span, (Tracer.SpanInScope)this);
        this.scopedSpans.addFirst(this.spanAndScope);
    }

    public void close() {
        this.closed = true;
        SpanAndScope first = this.scopedSpans.peekFirst();
        if (first != this.spanAndScope) {
            throw new IllegalStateException("Trying to close scope for span [" + this.span + "] but current span in scope is [" + (first != null ? first.getSpan() : null) + "]");
        }
        this.scopedSpans.remove(this.spanAndScope);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

