/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.reporter.wavefront;

import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.entities.tracing.SpanLog;
import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.reporter.wavefront.SpanMetrics;
import java.io.Closeable;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

@Deprecated
public class WavefrontSpanHandler
implements Runnable,
Closeable {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(WavefrontSpanHandler.class);
    private static final String DEFAULT_SPAN_NAME = "defaultOperation";
    private static final String DEFAULT_SOURCE = "micrometer-tracing";
    private static final String WAVEFRONT_GENERATED_COMPONENT = "wavefront-generated";
    private static final int LONG_BYTES = 8;
    private static final int BYTE_BASE16 = 2;
    private static final int LONG_BASE16 = 16;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final byte[] DECODING = WavefrontSpanHandler.buildDecodingArray();
    private final LinkedBlockingQueue<SpanToSend> spanBuffer;
    private final WavefrontSender wavefrontSender;
    private final WavefrontInternalReporter wfInternalReporter;
    private final Set<String> traceDerivedCustomTagKeys;
    private final Thread sendingThread;
    private final Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics;
    private final ScheduledExecutorService heartbeatMetricsScheduledExecutorService;
    private final String source;
    private final List<Pair<String, String>> defaultTags;
    private final Set<String> defaultTagKeys;
    private final ApplicationTags applicationTags;
    private final SpanMetrics spanMetrics;
    private final AtomicBoolean stop = new AtomicBoolean();
    private final AtomicLong spansDropped = new AtomicLong();

    public WavefrontSpanHandler(int maxQueueSize, WavefrontSender wavefrontSender, SpanMetrics spanMetrics, String source, ApplicationTags applicationTags, Set<String> redMetricsCustomTagKeys) {
        this.wavefrontSender = wavefrontSender;
        this.applicationTags = applicationTags;
        this.discoveredHeartbeatMetrics = ConcurrentHashMap.newKeySet();
        this.spanMetrics = spanMetrics;
        this.heartbeatMetricsScheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("micrometer-heart-beater").setDaemon(true));
        this.heartbeatMetricsScheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                SpanDerivedMetricsUtils.reportHeartbeats((WavefrontSender)wavefrontSender, this.discoveredHeartbeatMetrics, (String)WAVEFRONT_GENERATED_COMPONENT);
            }
            catch (IOException e) {
                LOG.warn("Cannot report heartbeat metric to wavefront");
            }
        }, 1L, 60L, TimeUnit.SECONDS);
        this.traceDerivedCustomTagKeys = new HashSet<String>(redMetricsCustomTagKeys);
        this.wfInternalReporter = new WavefrontInternalReporter.Builder().prefixedWith("tracing.derived").withSource(DEFAULT_SOURCE).reportMinuteDistribution().build(wavefrontSender);
        this.wfInternalReporter.start(1L, TimeUnit.MINUTES);
        this.source = source;
        this.defaultTags = WavefrontSpanHandler.createDefaultTags(applicationTags);
        this.defaultTagKeys = this.defaultTags.stream().map(p -> (String)p._1).collect(Collectors.toSet());
        this.defaultTagKeys.add("source");
        this.spanBuffer = new LinkedBlockingQueue(maxQueueSize);
        spanMetrics.registerQueueSize(this.spanBuffer);
        spanMetrics.registerQueueRemainingCapacity(this.spanBuffer);
        this.sendingThread = new Thread((Runnable)this, "wavefrontSpanReporter");
        this.sendingThread.setDaemon(true);
        this.sendingThread.start();
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    private static long longFromBase16String(CharSequence chars) {
        int offset = 0;
        return ((long)WavefrontSpanHandler.decodeByte(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)WavefrontSpanHandler.decodeByte(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)WavefrontSpanHandler.decodeByte(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)WavefrontSpanHandler.decodeByte(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)WavefrontSpanHandler.decodeByte(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)WavefrontSpanHandler.decodeByte(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)WavefrontSpanHandler.decodeByte(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)WavefrontSpanHandler.decodeByte(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
    }

    private static byte decodeByte(char hi, char lo) {
        int decoded = DECODING[hi] << 4 | DECODING[lo];
        return (byte)decoded;
    }

    static List<SpanLog> convertAnnotationsToSpanLogs(FinishedSpan span) {
        return span.getEvents().stream().map(entry -> new SpanLog(((Long)entry.getKey()).longValue(), Collections.singletonMap("annotation", (String)entry.getValue()))).collect(Collectors.toList());
    }

    static List<Pair<String, String>> createDefaultTags(ApplicationTags applicationTags) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        result.add(Pair.of((Object)"application", (Object)applicationTags.getApplication()));
        result.add(Pair.of((Object)"service", (Object)applicationTags.getService()));
        result.add(Pair.of((Object)"cluster", (Object)(applicationTags.getCluster() == null ? "none" : applicationTags.getCluster())));
        result.add(Pair.of((Object)"shard", (Object)(applicationTags.getShard() == null ? "none" : applicationTags.getShard())));
        if (applicationTags.getCustomTags() != null) {
            applicationTags.getCustomTags().forEach((k, v) -> result.add(Pair.of((Object)k, (Object)v)));
        }
        return result;
    }

    public boolean end(TraceContext context, FinishedSpan span) {
        this.spanMetrics.reportReceived();
        if (this.stop.get()) {
            this.spanMetrics.reportDropped();
            long dropped = this.spansDropped.incrementAndGet();
            if (LOG.isWarnEnabled()) {
                LOG.warn("Trying to send span after close() have been called, dropping span " + span);
                LOG.warn("Total spans dropped: " + dropped);
            }
        } else if (!this.spanBuffer.offer(new SpanToSend(context, span))) {
            this.spanMetrics.reportDropped();
            long dropped = this.spansDropped.incrementAndGet();
            if (LOG.isWarnEnabled()) {
                LOG.warn("Buffer full, dropping span: " + span);
                LOG.warn("Total spans dropped: " + dropped);
            }
        }
        return true;
    }

    List<Pair<String, String>> getDefaultTags() {
        return Collections.unmodifiableList(this.defaultTags);
    }

    private String padLeftWithZeros(String string, int length) {
        if (string.length() >= length) {
            return string;
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = string.length(); i < length; ++i) {
            sb.append('0');
        }
        return sb.append(string).toString();
    }

    private void send(TraceContext context, FinishedSpan span) {
        String traceIdString = this.padLeftWithZeros(context.traceId(), 32);
        String traceIdHigh = traceIdString.substring(0, traceIdString.length() / 2);
        String traceIdLow = traceIdString.substring(traceIdString.length() / 2);
        UUID traceId = new UUID(WavefrontSpanHandler.longFromBase16String(traceIdHigh), WavefrontSpanHandler.longFromBase16String(traceIdLow));
        UUID spanId = new UUID(0L, WavefrontSpanHandler.longFromBase16String(context.spanId()));
        List<UUID> parents = null;
        String parentId = context.parentId();
        if (!StringUtils.isEmpty((String)parentId) && WavefrontSpanHandler.longFromBase16String(parentId) != 0L) {
            parents = Collections.singletonList(new UUID(0L, WavefrontSpanHandler.longFromBase16String(parentId)));
        }
        List followsFrom = null;
        String name = span.getName();
        if (name == null) {
            name = DEFAULT_SPAN_NAME;
        }
        long startMillis = span.getStartTimestamp().toEpochMilli();
        long finishMillis = span.getEndTimestamp().toEpochMilli();
        long durationMicros = ChronoUnit.MICROS.between(span.getStartTimestamp(), span.getEndTimestamp());
        long durationMillis = startMillis != 0L && finishMillis != 0L ? Math.max(finishMillis - startMillis, 1L) : 0L;
        List<SpanLog> spanLogs = WavefrontSpanHandler.convertAnnotationsToSpanLogs(span);
        TagList tags = new TagList(this.defaultTagKeys, this.defaultTags, span);
        try {
            this.wavefrontSender.sendSpan(name, startMillis, durationMillis, this.source, traceId, spanId, parents, followsFrom, (List)tags, spanLogs);
        }
        catch (IOException | RuntimeException t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("error sending span " + context, (Throwable)t);
            }
            this.spanMetrics.reportErrors();
        }
        if (this.wfInternalReporter != null) {
            try {
                this.discoveredHeartbeatMetrics.add((Pair<Map<String, String>, String>)SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)this.wfInternalReporter, (String)name, (String)this.applicationTags.getApplication(), (String)this.applicationTags.getService(), (String)(this.applicationTags.getCluster() == null ? "none" : this.applicationTags.getCluster()), (String)(this.applicationTags.getShard() == null ? "none" : this.applicationTags.getShard()), (String)this.source, (String)tags.componentTagValue, (boolean)tags.isError, (long)durationMicros, this.traceDerivedCustomTagKeys, (List)tags));
            }
            catch (RuntimeException t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("error sending span RED metrics " + context, (Throwable)t);
                }
                this.spanMetrics.reportErrors();
            }
        }
    }

    @Override
    public void run() {
        while (!this.stop.get()) {
            try {
                SpanToSend spanToSend = this.spanBuffer.take();
                if (spanToSend == DeathPill.INSTANCE) {
                    LOG.info("reporting thread stopping");
                    return;
                }
                this.send(spanToSend.getTraceContext(), spanToSend.getFinishedSpan());
            }
            catch (InterruptedException ex) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("reporting thread interrupted");
            }
            catch (Throwable ex) {
                LOG.warn("Error processing buffer", ex);
            }
        }
    }

    @Override
    public void close() {
        if (!this.stop.compareAndSet(false, true)) {
            return;
        }
        try {
            this.spanBuffer.offer(DeathPill.INSTANCE);
            this.sendingThread.join(5000L);
            this.sendingThread.interrupt();
            this.heartbeatMetricsScheduledExecutorService.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.wavefrontSender.flush();
            this.wavefrontSender.close();
        }
        catch (IOException e) {
            LOG.warn("Unable to close Wavefront Client", (Throwable)e);
        }
    }

    private static class SpanToSend {
        private final TraceContext traceContext;
        private final FinishedSpan finishedSpan;

        SpanToSend(TraceContext traceContext, FinishedSpan finishedSpan) {
            this.traceContext = traceContext;
            this.finishedSpan = finishedSpan;
        }

        TraceContext getTraceContext() {
            return this.traceContext;
        }

        FinishedSpan getFinishedSpan() {
            return this.finishedSpan;
        }
    }

    static final class TagList
    extends ArrayList<Pair<String, String>> {
        String componentTagValue = "none";
        boolean isError;

        TagList(Set<String> defaultTagKeys, List<Pair<String, String>> defaultTags, FinishedSpan span) {
            super(defaultTags.size() + span.getTags().size());
            boolean debug = false;
            boolean hasAnnotations = span.getEvents().size() > 0;
            this.isError = span.getError() != null;
            this.addAll(defaultTags);
            for (Map.Entry tag : span.getTags().entrySet()) {
                String lowerCaseKey = ((String)tag.getKey()).toLowerCase(Locale.ROOT);
                if (lowerCaseKey.equals("error")) {
                    this.isError = true;
                    continue;
                }
                if (((String)tag.getValue()).isEmpty() || defaultTagKeys.contains(lowerCaseKey)) continue;
                if (lowerCaseKey.equals("debug")) {
                    debug = true;
                    continue;
                }
                if (lowerCaseKey.equals("component")) {
                    this.componentTagValue = (String)tag.getValue();
                }
                this.add(Pair.of((Object)((String)tag.getKey()), (Object)((String)tag.getValue())));
            }
            if (this.isError) {
                this.add(Pair.of((Object)"error", (Object)"true"));
            }
            if (debug) {
                this.add(Pair.of((Object)"debug", (Object)"true"));
            }
            if (span.getKind() != null) {
                String kind = span.getKind().toString().toLowerCase();
                this.add(Pair.of((Object)"span.kind", (Object)kind));
                if (hasAnnotations) {
                    this.add(Pair.of((Object)"_spanSecondaryId", (Object)kind));
                }
            }
            if (hasAnnotations) {
                this.add(Pair.of((Object)"_spanLogs", (Object)"true"));
            }
            if (span.getLocalIp() != null) {
                String localIp = span.getLocalIp();
                String version = localIp.contains(":") ? "ipv6" : "ipv4";
                this.add(Pair.of((Object)version, (Object)localIp));
            }
        }
    }

    private static class DeathPill
    extends SpanToSend {
        static final DeathPill INSTANCE = new DeathPill();

        private DeathPill() {
            super(null, null);
        }
    }
}

