/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class OtelSpan
implements Span {
    final io.opentelemetry.api.trace.Span delegate;
    private final AtomicReference<Context> context;

    OtelSpan(io.opentelemetry.api.trace.Span delegate) {
        this.delegate = delegate;
        if (delegate instanceof SpanFromSpanContext) {
            SpanFromSpanContext fromSpanContext = (SpanFromSpanContext)delegate;
            this.context = fromSpanContext.otelTraceContext.context;
        } else {
            this.context = new AtomicReference<Context>(Context.current());
        }
    }

    OtelSpan(io.opentelemetry.api.trace.Span delegate, Context context) {
        this.delegate = delegate;
        this.context = new AtomicReference<Context>(context);
    }

    static io.opentelemetry.api.trace.Span toOtel(Span span) {
        return ((OtelSpan)span).delegate;
    }

    static Span fromOtel(io.opentelemetry.api.trace.Span span) {
        return new OtelSpan(span);
    }

    static Span fromOtel(io.opentelemetry.api.trace.Span span, Context context) {
        return new OtelSpan(span, context);
    }

    public boolean isNoop() {
        return !this.delegate.isRecording();
    }

    public OtelTraceContext context() {
        if (this.delegate == null) {
            return null;
        }
        return new OtelTraceContext(this.context, this.delegate.getSpanContext(), this.delegate);
    }

    public Span start() {
        return this;
    }

    public Span name(String name) {
        this.delegate.updateName(name);
        return this;
    }

    public Span event(String value) {
        this.delegate.addEvent(value);
        return this;
    }

    public Span event(String value, long time, TimeUnit timeUnit) {
        this.delegate.addEvent(value, time, timeUnit);
        return null;
    }

    public Span tag(String key, String value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public void end(long time, TimeUnit timeUnit) {
        this.delegate.end(time, timeUnit);
    }

    public Span remoteIpAndPort(String ip, int port) {
        this.delegate.setAttribute(SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)ip);
        this.delegate.setAttribute(SemanticAttributes.NET_PEER_PORT, port);
        return this;
    }

    public Span error(Throwable throwable) {
        this.delegate.recordException(throwable);
        this.delegate.setStatus(StatusCode.ERROR, throwable.getMessage());
        return this;
    }

    public void end() {
        this.delegate.end();
    }

    public void abandon() {
    }

    public Span remoteServiceName(String remoteServiceName) {
        this.delegate.setAttribute("peer.service", remoteServiceName);
        return this;
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtelSpan otelSpan = (OtelSpan)o;
        io.opentelemetry.api.trace.Span span = otelSpan.delegate;
        if (span instanceof SpanFromSpanContext) {
            span = ((SpanFromSpanContext)span).span;
        }
        return Objects.equals(this.delegate, span);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

