/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class OtelCurrentTraceContext
implements CurrentTraceContext {
    public TraceContext context() {
        Span currentSpan = Span.current();
        if (Span.getInvalid().equals((Object)currentSpan)) {
            return null;
        }
        if (currentSpan instanceof SpanFromSpanContext) {
            return new OtelTraceContext((SpanFromSpanContext)currentSpan);
        }
        return new OtelTraceContext(currentSpan);
    }

    public CurrentTraceContext.Scope newScope(TraceContext context) {
        OtelTraceContext otelTraceContext = (OtelTraceContext)context;
        if (otelTraceContext == null) {
            return Scope::noop;
        }
        Context current = Context.current();
        Context old = otelTraceContext.context();
        Span currentSpan = Span.fromContext((Context)current);
        Span oldSpan = Span.fromContext((Context)otelTraceContext.context());
        SpanContext spanContext = otelTraceContext.delegate;
        boolean sameSpan = currentSpan.getSpanContext().equals((Object)oldSpan.getSpanContext()) && currentSpan.getSpanContext().equals((Object)spanContext);
        SpanFromSpanContext fromContext = new SpanFromSpanContext(((OtelTraceContext)context).span, spanContext, otelTraceContext);
        Baggage currentBaggage = Baggage.fromContext((Context)current);
        Baggage oldBaggage = Baggage.fromContext((Context)old);
        boolean sameBaggage = this.sameBaggage(currentBaggage, oldBaggage);
        if (sameSpan && sameBaggage) {
            return Scope::noop;
        }
        BaggageBuilder baggageBuilder = currentBaggage.toBuilder();
        oldBaggage.forEach((key, baggageEntry) -> baggageBuilder.put(key, baggageEntry.getValue(), baggageEntry.getMetadata()));
        Baggage updatedBaggage = baggageBuilder.build();
        Scope attach = old.with((ImplicitContextKeyed)fromContext).with((ImplicitContextKeyed)updatedBaggage).makeCurrent();
        return () -> ((Scope)attach).close();
    }

    private boolean sameBaggage(Baggage currentBaggage, Baggage oldBaggage) {
        return currentBaggage.equals((Object)oldBaggage);
    }

    public CurrentTraceContext.Scope maybeScope(TraceContext context) {
        if (context == null) {
            Scope scope = Context.current().with((ImplicitContextKeyed)Span.getInvalid()).makeCurrent();
            return () -> ((Scope)scope).close();
        }
        return this.newScope(context);
    }

    public <C> Callable<C> wrap(Callable<C> task) {
        return Context.current().wrap(task);
    }

    public Runnable wrap(Runnable task) {
        return Context.current().wrap(task);
    }

    public Executor wrap(Executor delegate) {
        return Context.current().wrap(delegate);
    }

    public ExecutorService wrap(ExecutorService delegate) {
        return Context.current().wrap(delegate);
    }
}

