/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.tck.CounterTest;
import io.micrometer.core.tck.DistributionSummaryTest;
import io.micrometer.core.tck.GaugeTest;
import io.micrometer.core.tck.LongTaskTimerTest;
import io.micrometer.core.tck.RegistryResolver;
import io.micrometer.core.tck.TimerTest;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RegistryResolver.class})
public abstract class MeterRegistryCompatibilityKit {
    private final Object o = new Object();

    public abstract MeterRegistry registry();

    public abstract Duration step();

    @Test
    @DisplayName(value="compatibility test provides a non-null registry instance")
    void registryIsNotNull(MeterRegistry registry) {
        Assertions.assertThat((Object)registry).isNotNull();
    }

    @Test
    @DisplayName(value="meters with the same name and tags are registered once")
    void uniqueMeters(MeterRegistry registry) {
        registry.counter("foo", new String[0]);
        registry.counter("foo", new String[0]);
        Assertions.assertThat((int)registry.get("foo").meters().size()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="find meters by name and class type matching a subset of their tags")
    void findMeters(MeterRegistry registry) {
        Counter c1 = registry.counter("foo", new String[]{"k", "v"});
        Counter c2 = registry.counter("bar", new String[]{"k", "v", "k2", "v"});
        Assertions.assertThat((Object)registry.get("foo").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c1);
        Assertions.assertThat((Object)registry.get("bar").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c2);
    }

    @Test
    @DisplayName(value="find meters by name and type matching a subset of their tags")
    void findMetersByType(MeterRegistry registry) {
        Counter c1 = registry.counter("foo", new String[]{"k", "v"});
        Counter c2 = registry.counter("bar", new String[]{"k", "v", "k2", "v"});
        Assertions.assertThat((Object)registry.get("foo").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c1);
        Assertions.assertThat((Object)registry.get("bar").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c2);
    }

    @Test
    @DisplayName(value="find meters by name and value")
    void findMetersByValue(MeterRegistry registry) {
        Counter c = registry.counter("counter", new String[0]);
        c.increment();
        Timer t = registry.timer("timer", new String[0]);
        t.record(10L, TimeUnit.NANOSECONDS);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        Assertions.assertThat((double)registry.get("counter").counter().count()).isEqualTo(1.0);
        Assertions.assertThat((long)registry.get("timer").timer().count()).isEqualTo(1L);
        Assertions.assertThat((double)registry.get("timer").timer().totalTime(TimeUnit.NANOSECONDS)).isEqualTo(10.0);
    }

    @Test
    @DisplayName(value="common tags are added to every measurement")
    void addCommonTags(MeterRegistry registry) {
        registry.config().commonTags(new String[]{"k", "v"});
        Counter c = registry.counter("foo", new String[0]);
        Assertions.assertThat((Object)registry.get("foo").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c);
        Assertions.assertThat((Iterable)c.getId().getTagsAsIterable()).hasSize(1);
    }

    @Test
    @DisplayName(value="original and convention names are preserved for custom meter types")
    void aTaleOfTwoNames(MeterRegistry registry) {
        AtomicInteger n = new AtomicInteger(1);
        registry.more().counter("my.counter", Collections.emptyList(), (Number)n);
        registry.get("my.counter").functionCounter();
    }

    @Test
    @DisplayName(value="function timers respect the base unit of an underlying registry")
    void functionTimerUnits(MeterRegistry registry) {
        registry.more().timer("function.timer", Collections.emptyList(), this.o, o2 -> 1L, o2 -> 1.0, TimeUnit.MILLISECONDS);
        FunctionTimer ft = registry.get("function.timer").functionTimer();
        MockClock.clock((MeterRegistry)registry).add(this.step());
        Assertions.assertThat((Iterable)ft.measure()).anySatisfy(ms -> {
            TimeUnit baseUnit = TimeUnit.valueOf(Objects.requireNonNull(ft.getId().getBaseUnit()).toUpperCase());
            Assertions.assertThat((Comparable)ms.getStatistic()).isEqualTo((Object)Statistic.TOTAL_TIME);
            Assertions.assertThat((double)TimeUtils.convert((double)ms.getValue(), (TimeUnit)baseUnit, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(1.0);
        });
    }

    @Test
    @DisplayName(value="meters with synthetics can be removed without causing deadlocks")
    void removeMeterWithSynthetic(MeterRegistry registry) {
        Timer timer = Timer.builder((String)"my.timer").publishPercentiles(new double[]{0.95}).sla(new Duration[]{Duration.ofMillis(10L)}).register(registry);
        registry.remove((Meter)timer);
    }

    @DisplayName(value="timers")
    @Nested
    class TimerTck
    implements TimerTest {
        TimerTck() {
        }

        @Override
        public Duration step() {
            return MeterRegistryCompatibilityKit.this.step();
        }
    }

    @DisplayName(value="long task timers")
    @Nested
    class LongTaskTimerTck
    implements LongTaskTimerTest {
        LongTaskTimerTck() {
        }
    }

    @DisplayName(value="gauges")
    @Nested
    class GaugeTck
    implements GaugeTest {
        GaugeTck() {
        }
    }

    @DisplayName(value="distribution summaries")
    @Nested
    class DistributionSummaryTck
    implements DistributionSummaryTest {
        DistributionSummaryTck() {
        }

        @Override
        public Duration step() {
            return MeterRegistryCompatibilityKit.this.step();
        }
    }

    @DisplayName(value="counters")
    @Nested
    class CounterTck
    implements CounterTest {
        CounterTck() {
        }

        @Override
        public Duration step() {
            return MeterRegistryCompatibilityKit.this.step();
        }
    }
}

