/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.InstrumentationTimingVerificationTests;
import io.micrometer.core.instrument.InstrumentationVerificationTests;
import io.micrometer.core.instrument.search.RequiredSearch;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.tck.TestObservationRegistry;
import io.micrometer.observation.tck.TestObservationRegistryAssert;
import io.micrometer.observation.transport.ReceiverContext;
import java.net.URI;
import java.time.Duration;
import java.util.function.Function;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.awaitility.Awaitility;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@ExtendWith(value={InstrumentationVerificationTests.AfterBeforeParameterResolver.class})
@Incubating(since="1.8.9")
public abstract class HttpServerTimingInstrumentationVerificationTests
extends InstrumentationTimingVerificationTests {
    private final HttpSender sender = new HttpUrlConnectionSender();
    private @Nullable URI baseUri;
    private boolean assumptionSucceeded = true;

    @Override
    protected String timerName() {
        return "http.server.requests";
    }

    protected abstract URI startInstrumentedWithMetricsServer() throws Exception;

    protected abstract @Nullable URI startInstrumentedWithObservationsServer() throws Exception;

    protected abstract void stopInstrumentedServer() throws Exception;

    @BeforeEach
    void beforeEach(InstrumentationVerificationTests.TestType testType) throws Exception {
        if (testType == InstrumentationVerificationTests.TestType.METRICS_VIA_METER_REGISTRY) {
            this.baseUri = this.startInstrumentedWithMetricsServer();
        } else {
            this.baseUri = this.startInstrumentedWithObservationsServer();
            this.assumptionSucceeded = this.baseUri != null;
            Assumptions.assumeTrue((boolean)this.assumptionSucceeded, (String)"You must implement the <startInstrumentedWithObservationsServer> method to test your instrumentation against an ObservationRegistry");
        }
    }

    @AfterEach
    void afterEach() throws Exception {
        if (this.assumptionSucceeded) {
            this.stopInstrumentedServer();
        }
    }

    @ParameterizedTest
    @EnumSource
    void uriIsNotFound_whenRouteIsUnmapped(InstrumentationVerificationTests.TestType testType) throws Throwable {
        this.sender.get(this.baseUri + "notFound").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "NOT_FOUND", "status", "404", "method", "GET"}).timer().count() == 1L);
    }

    @ParameterizedTest
    @EnumSource
    void uriTemplateIsTagged(InstrumentationVerificationTests.TestType testType) throws Throwable {
        this.sender.get(this.baseUri + "hello/world").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "/hello/{name}", "status", "200", "method", "GET"}).timer().count() == 1L);
    }

    @ParameterizedTest
    @EnumSource
    void redirect(InstrumentationVerificationTests.TestType testType) throws Throwable {
        this.sender.get(this.baseUri + "foundRedirect").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "/foundRedirect", "status", "302", "method", "GET"}).timer().count() == 1L);
    }

    @ParameterizedTest
    @EnumSource
    void errorResponse(InstrumentationVerificationTests.TestType testType) throws Throwable {
        this.sender.post(this.baseUri + "error").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "/error", "status", "500", "method", "POST"}).timer().count() == 1L);
    }

    @ParameterizedTest
    @EnumSource
    void canExtractContextFromHeaders(InstrumentationVerificationTests.TestType testType) throws Throwable {
        this.sender.get(this.baseUri + "hello/micrometer").withHeader("Test-Propagation", "someValue").send();
        Assumptions.assumeTrue((testType == InstrumentationVerificationTests.TestType.METRICS_VIA_OBSERVATIONS_WITH_METRICS_HANDLER ? 1 : 0) != 0);
        ((TestObservationRegistryAssert)Assertions.assertThat((AssertProvider)this.getObservationRegistry())).hasSingleObservationThat().has(new Condition(context -> "someValue".contentEquals((CharSequence)context.getRequired((Object)"Test-Propagation")), "has Test-Propagation in context with value 'someValue'", new Object[0]));
    }

    @Override
    protected TestObservationRegistry createObservationRegistryWithMetrics() {
        TestObservationRegistry observationRegistryWithMetrics = super.createObservationRegistryWithMetrics();
        observationRegistryWithMetrics.observationConfig().observationHandler(new ExtractHeaderObservationHandler());
        return observationRegistryWithMetrics;
    }

    private void checkTimer(Function<RequiredSearch, Boolean> timerCheck) {
        Awaitility.await().atLeast(Duration.ofMillis(25L)).atMost(Duration.ofMillis(150L)).until(() -> (Boolean)timerCheck.apply(this.getRegistry().get(this.timerName())));
    }

    static class ExtractHeaderObservationHandler<T extends ReceiverContext>
    implements ObservationHandler<T> {
        ExtractHeaderObservationHandler() {
        }

        public void onStart(T context) {
            Object carrier = context.getCarrier();
            if (carrier == null) {
                return;
            }
            String testPropagation = context.getGetter().get(carrier, "Test-Propagation");
            if (testPropagation != null) {
                context.put((Object)"Test-Propagation", (Object)testPropagation);
            }
        }

        public boolean supportsContext(Observation.Context context) {
            return context instanceof ReceiverContext;
        }
    }

    public static class InstrumentedRoutes {
        public static final String TEMPLATED_ROUTE = "/hello/{name}";
        public static final String ROOT = "/";
        public static final String ERROR = "/error";
        public static final String REDIRECT = "/foundRedirect";
    }
}

