/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.jersey;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.jersey2.server.AnnotationFinder;
import io.micrometer.jersey2.server.DefaultJerseyTagsProvider;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import io.micrometer.jersey2.server.MetricsApplicationEventListener;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.autoconfigure.OnlyOnceLoggingDenyMeterFilter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnWebApplication
@ConditionalOnClass(value={ResourceConfig.class, MetricsApplicationEventListener.class})
@Conditional(value={JerseyServerMetricsConditionalOnBeans.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class JerseyServerMetricsAutoConfiguration {
    private final MetricsProperties properties;

    public JerseyServerMetricsAutoConfiguration(MetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={JerseyTagsProvider.class})
    public DefaultJerseyTagsProvider jerseyTagsProvider() {
        return new DefaultJerseyTagsProvider();
    }

    @Bean
    public ResourceConfigCustomizer jerseyServerMetricsResourceConfigCustomizer(MeterRegistry meterRegistry, JerseyTagsProvider tagsProvider) {
        MetricsProperties.Web.Server server = this.properties.getWeb().getServer();
        return config -> config.register((Object)new MetricsApplicationEventListener(meterRegistry, tagsProvider, server.getRequestsMetricName(), server.isAutoTimeRequests(), (AnnotationFinder)new AnnotationUtilsAnnotationFinder()));
    }

    @Bean
    @Order(value=0)
    public MeterFilter jerseyMetricsUriTagFilter() {
        String metricName = this.properties.getWeb().getServer().getRequestsMetricName();
        OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", metricName));
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)this.properties.getWeb().getServer().getMaxUriTags(), (MeterFilter)filter);
    }

    static class JerseyServerMetricsConditionalOnBeans
    extends AllNestedConditions {
        JerseyServerMetricsConditionalOnBeans() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={ResourceConfig.class})
        static class ConditionalOnResourceConfigBean {
            ConditionalOnResourceConfigBean() {
            }
        }

        @ConditionalOnBean(value={MeterRegistry.class})
        static class ConditionalOnMeterRegistryBean {
            ConditionalOnMeterRegistryBean() {
            }
        }
    }

    private static class AnnotationUtilsAnnotationFinder
    implements AnnotationFinder {
        private AnnotationUtilsAnnotationFinder() {
        }

        public <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
            return (A)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, annotationType);
        }
    }
}

