/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.influx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.influx.InfluxProperties;
import io.micrometer.spring.autoconfigure.export.influx.InfluxPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={InfluxMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.influx", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={InfluxProperties.class})
@Import(value={StringToDurationConverter.class})
public class InfluxMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={InfluxConfig.class})
    public InfluxConfig influxConfig(InfluxProperties props) {
        return new InfluxPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public InfluxMeterRegistry influxMeterRegistry(InfluxConfig config, Clock clock) {
        return new InfluxMeterRegistry(config, clock);
    }
}

