/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

class WavefrontLongTaskTimer
extends DefaultLongTaskTimer {
    private final @Nullable WavefrontHistogramImpl histogram;

    WavefrontLongTaskTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, TimeUnit baseTimeUnit) {
        super(id, clock, baseTimeUnit, distributionStatisticConfig, false);
        this.histogram = distributionStatisticConfig.isPublishingHistogram() ? new WavefrontHistogramImpl(() -> ((Clock)clock).wallTime()) : null;
    }

    List<WavefrontHistogramImpl.Distribution> flushDistributions() {
        if (this.histogram == null) {
            return Collections.emptyList();
        }
        this.forEachActive(s -> this.histogram.update(s.duration(this.baseTimeUnit())));
        return this.histogram.flushDistributions();
    }

    boolean isPublishingHistogram() {
        return this.histogram != null;
    }
}

