/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.lang.Nullable;

public class WavefrontNamingConvention
implements NamingConvention {
    private final NamingConvention delegate;
    @Nullable
    private String namePrefix;

    public WavefrontNamingConvention(@Nullable String namePrefix) {
        this(namePrefix, NamingConvention.dot);
    }

    public WavefrontNamingConvention(@Nullable String namePrefix, NamingConvention delegate) {
        this.delegate = delegate;
        this.namePrefix = namePrefix != null && namePrefix.isEmpty() ? null : namePrefix;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String sanitizedName = this.delegate.name(name, type, baseUnit).replaceAll("[^a-zA-Z0-9\\-_\\./,]", "_");
        if (this.namePrefix != null) {
            return this.namePrefix + "." + sanitizedName;
        }
        return sanitizedName;
    }

    public String tagKey(String key) {
        return this.delegate.tagKey(key).replaceAll("[^a-zA-Z0-9\\-_\\.]", "_");
    }

    public String tagValue(String value) {
        String sanitized = this.delegate.tagValue(value);
        return StringEscapeUtils.escapeJson((String)(sanitized.endsWith("\\") ? sanitized.substring(0, sanitized.length() - 1) + "_" : sanitized));
    }
}

