/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.udp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.socket.InternetProtocolFamily;
import io.micrometer.shaded.io.netty.handler.logging.LogLevel;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.io.netty.util.NetUtil;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.udp.UdpClientBootstrap;
import io.micrometer.shaded.reactor.netty.udp.UdpClientConnect;
import io.micrometer.shaded.reactor.netty.udp.UdpClientDoOn;
import io.micrometer.shaded.reactor.netty.udp.UdpClientObserve;
import io.micrometer.shaded.reactor.netty.udp.UdpClientRunOn;
import io.micrometer.shaded.reactor.netty.udp.UdpInbound;
import io.micrometer.shaded.reactor.netty.udp.UdpOperations;
import io.micrometer.shaded.reactor.netty.udp.UdpOutbound;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.Metrics;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class UdpClient {
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;
    static final Bootstrap DEFAULT_BOOTSTRAP = ((Bootstrap)new Bootstrap().option(ChannelOption.AUTO_READ, false)).remoteAddress(NetUtil.LOCALHOST, DEFAULT_PORT);
    static final LoggingHandler LOGGING_HANDLER;
    static final Logger log;

    public static UdpClient create() {
        return UdpClientConnect.INSTANCE;
    }

    @Deprecated
    public final UdpClient addressSupplier(Supplier<? extends SocketAddress> connectingAddressSupplier) {
        return this.remoteAddress(connectingAddressSupplier);
    }

    public final UdpClient remoteAddress(Supplier<? extends SocketAddress> remoteAddressSupplier) {
        Objects.requireNonNull(remoteAddressSupplier, "remoteAddressSupplier");
        return this.bootstrap(b -> b.remoteAddress((SocketAddress)remoteAddressSupplier.get()));
    }

    public final <T> UdpClient attr(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return this.bootstrap(b -> (Bootstrap)b.attr(key, value));
    }

    public final UdpClient bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        Objects.requireNonNull(bindAddressSupplier, "bindAddressSupplier");
        return this.bootstrap(b -> (Bootstrap)b.localAddress((SocketAddress)bindAddressSupplier.get()));
    }

    @Deprecated
    public final UdpClient bootstrap(Function<? super Bootstrap, ? extends Bootstrap> bootstrapMapper) {
        return new UdpClientBootstrap(this, bootstrapMapper);
    }

    public final Mono<? extends Connection> connect() {
        Bootstrap b;
        try {
            b = this.configure();
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal(t);
            return Mono.error(t);
        }
        return this.connect(b);
    }

    public final Connection connectNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull(this.connect().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("UdpClient couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final UdpClient doOnConnect(Consumer<? super Bootstrap> doOnConnect) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        return new UdpClientDoOn(this, doOnConnect, null, null);
    }

    public final UdpClient doOnConnected(Consumer<? super Connection> doOnConnected) {
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        return new UdpClientDoOn(this, null, doOnConnected, null);
    }

    public final UdpClient doOnDisconnected(Consumer<? super Connection> doOnDisconnected) {
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        return new UdpClientDoOn(this, null, null, doOnDisconnected);
    }

    @Deprecated
    public final UdpClient doOnLifecycle(Consumer<? super Bootstrap> doOnConnect, Consumer<? super Connection> doOnConnected, Consumer<? super Connection> doOnDisconnected) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        return new UdpClientDoOn(this, doOnConnect, doOnConnected, doOnDisconnected);
    }

    public final UdpClient host(String host) {
        Objects.requireNonNull(host, "host");
        return this.bootstrap(b -> b.remoteAddress(host, UdpClient.getPort(b)));
    }

    public final UdpClient handle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnConnected(c -> {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), handler);
            }
            Mono.fromDirect((Publisher)handler.apply((UdpInbound)((Object)c), (UdpOutbound)((Object)c))).subscribe(c.disposeSubscriber());
        });
    }

    public final UdpClient observe(ConnectionObserver observer) {
        return new UdpClientObserve(this, observer);
    }

    public final <T> UdpClient option(ChannelOption<T> key, T value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return this.bootstrap(b -> (Bootstrap)b.option(key, value));
    }

    public final UdpClient port(int port) {
        return this.bootstrap(b -> b.remoteAddress(UdpClient.getHost(b), port));
    }

    public final UdpClient runOn(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return this.runOn((boolean preferNative) -> eventLoopGroup);
    }

    public final UdpClient runOn(LoopResources channelResources) {
        return this.runOn(channelResources, LoopResources.DEFAULT_NATIVE);
    }

    public final UdpClient runOn(LoopResources channelResources, boolean preferNative) {
        return new UdpClientRunOn(this, channelResources, preferNative, null);
    }

    public final UdpClient runOn(LoopResources channelResources, InternetProtocolFamily family) {
        return new UdpClientRunOn(this, channelResources, false, family);
    }

    public final UdpClient metrics(boolean metricsEnabled) {
        if (metricsEnabled) {
            if (!Metrics.isInstrumentationAvailable()) {
                throw new UnsupportedOperationException("To enable metrics, you must add the dependency `io.micrometer:micrometer-core` to the class path first");
            }
            return this.bootstrap(b -> BootstrapHandlers.updateMetricsSupport(b, (ChannelMetricsRecorder)MicrometerUdpClientMetricsRecorder.INSTANCE));
        }
        return this.bootstrap(BootstrapHandlers::removeMetricsSupport);
    }

    @Deprecated
    public final UdpClient metrics(boolean metricsEnabled, ChannelMetricsRecorder recorder) {
        if (metricsEnabled) {
            Objects.requireNonNull(recorder, "recorder");
            return this.bootstrap(b -> BootstrapHandlers.updateMetricsSupport(b, recorder));
        }
        return this.bootstrap(BootstrapHandlers::removeMetricsSupport);
    }

    public final UdpClient metrics(boolean metricsEnabled, Supplier<? extends ChannelMetricsRecorder> recorder) {
        if (metricsEnabled) {
            Objects.requireNonNull(recorder, "recorder");
            return this.bootstrap(b -> BootstrapHandlers.updateMetricsSupport(b, (ChannelMetricsRecorder)recorder.get()));
        }
        return this.bootstrap(BootstrapHandlers::removeMetricsSupport);
    }

    public final UdpClient wiretap(boolean enable) {
        if (enable) {
            return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER));
        }
        return this.bootstrap(b -> BootstrapHandlers.removeConfiguration(b, "io.micrometer.shaded.reactor.left.loggingHandler"));
    }

    public final UdpClient wiretap(String category) {
        return this.wiretap(category, LogLevel.DEBUG);
    }

    public final UdpClient wiretap(String category, LogLevel level) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, new LoggingHandler(category, level)));
    }

    protected Bootstrap configure() {
        return DEFAULT_BOOTSTRAP.clone();
    }

    protected abstract Mono<? extends Connection> connect(Bootstrap var1);

    static String getHost(Bootstrap b) {
        if (b.config().remoteAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)b.config().remoteAddress()).getHostString();
        }
        return NetUtil.LOCALHOST.getHostAddress();
    }

    static int getPort(Bootstrap b) {
        if (b.config().remoteAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)b.config().remoteAddress()).getPort();
        }
        return DEFAULT_PORT;
    }

    static {
        BootstrapHandlers.channelOperationFactory(DEFAULT_BOOTSTRAP, (ch, c, msg) -> new UdpOperations(ch, c));
        LOGGING_HANDLER = new LoggingHandler(UdpClient.class);
        log = Loggers.getLogger(UdpClient.class);
    }

    static final class MicrometerUdpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerUdpClientMetricsRecorder INSTANCE = new MicrometerUdpClientMetricsRecorder("io.micrometer.shaded.reactor.netty.udp.client", "udp");

        MicrometerUdpClientMetricsRecorder(String name, String protocol) {
            super(name, protocol);
        }
    }
}

