/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.TcpServer;
import io.micrometer.shaded.reactor.netty.tcp.TcpServerOperator;
import java.util.Objects;

final class TcpServerRunOn
extends TcpServerOperator {
    final LoopResources loopResources;
    final boolean preferNative;

    TcpServerRunOn(TcpServer server, LoopResources loopResources, boolean preferNative) {
        super(server);
        this.loopResources = Objects.requireNonNull(loopResources, "loopResources");
        this.preferNative = preferNative;
    }

    @Override
    public ServerBootstrap configure() {
        ServerBootstrap b = this.source.configure();
        TcpServerRunOn.configure(b, this.preferNative, this.loopResources);
        return b;
    }

    static void configure(ServerBootstrap b, boolean preferNative, LoopResources resources) {
        EventLoopGroup selectorGroup = resources.onServerSelect(preferNative);
        EventLoopGroup elg = resources.onServer(preferNative);
        b.group(selectorGroup, elg).channel(resources.onServerChannel(elg));
    }
}

