/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.DisposableServer;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.tcp.TcpServer;
import io.micrometer.shaded.reactor.netty.tcp.TcpServerOperator;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class TcpServerDoOn
extends TcpServerOperator
implements ConnectionObserver {
    final Consumer<? super ServerBootstrap> onBind;
    final Consumer<? super DisposableServer> onBound;
    final Consumer<? super DisposableServer> onUnbound;

    TcpServerDoOn(TcpServer server, @Nullable Consumer<? super ServerBootstrap> onBind, @Nullable Consumer<? super DisposableServer> onBound, @Nullable Consumer<? super DisposableServer> onUnbound) {
        super(server);
        this.onBind = onBind;
        this.onBound = onBound;
        this.onUnbound = onUnbound;
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONNECTED) {
            if (this.onBound != null) {
                this.onBound.accept((DisposableServer)((Object)connection));
            }
            if (this.onUnbound != null) {
                connection.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.onUnbound.accept((DisposableServer)((Object)connection))));
            }
            return;
        }
    }

    @Override
    public Mono<? extends DisposableServer> bind(ServerBootstrap b) {
        if (this.onBind != null) {
            return this.source.bind(b).doOnSubscribe(s -> this.onBind.accept(b));
        }
        return this.source.bind(b);
    }

    @Override
    public ServerBootstrap configure() {
        ServerBootstrap b = this.source.configure();
        ConnectionObserver observer = BootstrapHandlers.connectionObserver(b);
        BootstrapHandlers.connectionObserver(b, observer.then(this));
        return b;
    }
}

