/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class TelegrafStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private final Object conventionTagsLock = new Object();
    private volatile NamingConvention namingConvention;
    private volatile String name;
    private volatile @Nullable String conventionTags;
    private volatile String tagsNoStat;
    private final ConcurrentMap<Statistic, String> tags = new ConcurrentHashMap<Statistic, String>();

    public TelegrafStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config) {
        super(id, config);
        this.namingConvention = config.namingConvention();
        this.conventionTags = this.createConventionTags(this.namingConvention);
        this.name = this.createName(this.namingConvention);
        this.tagsNoStat = this.createTagsNoStat(this.conventionTags);
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.name + this.tagsByStatistic(stat) + ":" + amount + "|" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            Object object = this.conventionTagsLock;
            synchronized (object) {
                if (this.namingConvention == next) {
                    return;
                }
                this.tags.clear();
                this.conventionTags = this.createConventionTags(next);
            }
            this.name = this.createName(next);
            this.tagsNoStat = this.createTagsNoStat(this.conventionTags);
            this.namingConvention = next;
        }
    }

    private @Nullable String createConventionTags(NamingConvention namingConvention) {
        return this.id.getTagsAsIterable().iterator().hasNext() ? this.id.getConventionTags(namingConvention).stream().map(t -> this.telegrafEscape(t.getKey()) + "=" + this.telegrafEscape(t.getValue())).collect(Collectors.joining(",")) : null;
    }

    private String createName(NamingConvention namingConvention) {
        return this.telegrafEscape(namingConvention.name(this.id.getName(), this.id.getType(), this.id.getBaseUnit()));
    }

    private String createTagsNoStat(@Nullable String conventionTags) {
        return this.tags(null, conventionTags, "=", ",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tagsByStatistic(@Nullable Statistic stat) {
        if (stat == null) {
            return this.tagsNoStat;
        }
        String tags = (String)this.tags.get(stat);
        if (tags != null) {
            return tags;
        }
        Object object = this.conventionTagsLock;
        synchronized (object) {
            return this.tags.computeIfAbsent(stat, key -> this.tags(stat, this.conventionTags, "=", ","));
        }
    }

    private String telegrafEscape(String value) {
        return value.replaceAll("[\\s,:]", "_");
    }
}

