/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;

public class EtsyStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private final HierarchicalNameMapper nameMapper;
    private volatile NamingConvention namingConvention;
    private volatile @Nullable String nameNoStat;
    private final ConcurrentMap<Statistic, String> names = new ConcurrentHashMap<Statistic, String>();

    public EtsyStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config, HierarchicalNameMapper nameMapper) {
        super(id, config);
        this.nameMapper = nameMapper;
        this.namingConvention = config.namingConvention();
        this.nameNoStat = null;
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.nameByStatistic(stat) + ":" + amount + "|" + type;
    }

    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            this.namingConvention = next;
            this.nameNoStat = null;
            this.names.clear();
        }
    }

    private String nameByStatistic(@Nullable Statistic stat) {
        if (stat == null) {
            if (this.nameNoStat == null) {
                this.nameNoStat = this.etsyName(null);
            }
            return this.nameNoStat;
        }
        return this.names.computeIfAbsent(stat, this::etsyName);
    }

    private String etsyName(@Nullable Statistic stat) {
        return this.nameMapper.toHierarchicalName(stat != null ? this.id.withTag(stat) : this.id, this.config.namingConvention()).replace(':', '_');
    }
}

