/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import io.micrometer.shaded.statsd.org.pcollections.HashTreePMap;
import io.micrometer.shaded.statsd.org.pcollections.PMap;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TelegrafStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private static final Pattern PATTERN_SPECIAL_CHARACTERS = Pattern.compile("([, =:])");
    private static final AtomicReferenceFieldUpdater<TelegrafStatsdLineBuilder, NamingConvention> namingConventionUpdater = AtomicReferenceFieldUpdater.newUpdater(TelegrafStatsdLineBuilder.class, NamingConvention.class, "namingConvention");
    private volatile NamingConvention namingConvention;
    private volatile String name;
    @Nullable
    private volatile String conventionTags;
    private volatile String tagsNoStat;
    private final Object tagsLock = new Object();
    private volatile PMap<Statistic, String> tags = HashTreePMap.empty();

    public TelegrafStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config) {
        super(id, config);
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.name + this.tagsByStatistic(stat) + ":" + amount + "|" + type;
    }

    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            while (!namingConventionUpdater.compareAndSet(this, this.namingConvention, next)) {
            }
            this.name = this.telegrafEscape(next.name(this.id.getName(), this.id.getType(), this.id.getBaseUnit()));
            this.tags = HashTreePMap.empty();
            this.conventionTags = this.id.getTags().iterator().hasNext() ? this.id.getConventionTags(this.namingConvention).stream().map(t -> this.telegrafEscape(t.getKey()) + "=" + this.telegrafEscape(t.getValue())).collect(Collectors.joining(",")) : null;
            this.tagsNoStat = this.tags(null, this.conventionTags, "=", ",");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tagsByStatistic(@Nullable Statistic stat) {
        if (stat == null) {
            return this.tagsNoStat;
        }
        String tagString = (String)this.tags.get(stat);
        if (tagString != null) {
            return tagString;
        }
        Object object = this.tagsLock;
        synchronized (object) {
            tagString = (String)this.tags.get(stat);
            if (tagString != null) {
                return tagString;
            }
            tagString = this.tags(stat, this.conventionTags, "=", ",");
            this.tags = this.tags.plus(stat, tagString);
            return tagString;
        }
    }

    private String telegrafEscape(String value) {
        return PATTERN_SPECIAL_CHARACTERS.matcher(value).replaceAll("\\\\$1");
    }
}

