/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.ServerChannel;
import io.micrometer.shaded.io.netty.channel.pool.ChannelPool;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.ipc.netty.resources.PoolResources;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TcpResources
implements PoolResources,
LoopResources {
    final PoolResources defaultPools;
    final LoopResources defaultLoops;
    static final AtomicReference<TcpResources> tcpResources;
    static final BiFunction<LoopResources, PoolResources, TcpResources> ON_TCP_NEW;

    public static TcpResources get() {
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(PoolResources pools) {
        return TcpResources.getOrCreate(tcpResources, null, pools, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(LoopResources loops) {
        return TcpResources.getOrCreate(tcpResources, loops, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources reset() {
        TcpResources.shutdown();
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static void shutdown() {
        TcpResources resources = tcpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> shutdownLater() {
        return Mono.defer(() -> {
            TcpResources resources = tcpResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater();
            }
            return Mono.empty();
        });
    }

    protected TcpResources(LoopResources defaultLoops, PoolResources defaultPools) {
        this.defaultLoops = defaultLoops;
        this.defaultPools = defaultPools;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    protected void _dispose() {
        this.defaultPools.dispose();
        this.defaultLoops.dispose();
    }

    protected Mono<Void> _disposeLater() {
        return Mono.when(this.defaultLoops.disposeLater(), this.defaultPools.disposeLater());
    }

    @Override
    public boolean isDisposed() {
        return this.defaultLoops.isDisposed() && this.defaultPools.isDisposed();
    }

    @Override
    public ChannelPool selectOrCreate(SocketAddress address, Supplier<? extends Bootstrap> bootstrap, Consumer<? super Channel> onChannelCreate, EventLoopGroup group) {
        return this.defaultPools.selectOrCreate(address, bootstrap, onChannelCreate, group);
    }

    @Override
    public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.defaultLoops.onChannel(group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.defaultLoops.onDatagramChannel(group);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.defaultLoops.onServerChannel(group);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    @Override
    public boolean preferNative() {
        return this.defaultLoops.preferNative();
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    protected static <T extends TcpResources> T getOrCreate(AtomicReference<T> ref, LoopResources loops, PoolResources pools, BiFunction<LoopResources, PoolResources, T> onNew, String name) {
        TcpResources resources;
        while ((resources = (TcpResources)ref.get()) == null || loops != null || pools != null) {
            TcpResources update = TcpResources.create(resources, loops, pools, name, onNew);
            if (ref.compareAndSet(resources, update)) {
                if (resources != null) {
                    if (loops != null) {
                        resources.defaultLoops.dispose();
                    }
                    if (pools != null) {
                        resources.defaultPools.dispose();
                    }
                }
                return (T)update;
            }
            update._dispose();
        }
        return (T)resources;
    }

    static <T extends TcpResources> T create(T previous, LoopResources loops, PoolResources pools, String name, BiFunction<LoopResources, PoolResources, T> onNew) {
        if (previous == null) {
            loops = loops == null ? LoopResources.create("io.micrometer.shaded.reactor-" + name) : loops;
            pools = pools == null ? PoolResources.elastic(name) : pools;
        } else {
            loops = loops == null ? previous.defaultLoops : loops;
            pools = pools == null ? previous.defaultPools : pools;
        }
        return (T)((TcpResources)onNew.apply(loops, pools));
    }

    static {
        ON_TCP_NEW = TcpResources::new;
        tcpResources = new AtomicReference();
    }
}

