/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.client;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.ipc.netty.http.client.HttpClientOperations;
import io.micrometer.shaded.reactor.ipc.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.ipc.netty.http.websocket.WebsocketOutbound;
import java.net.URI;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;

final class HttpClientWSOperations
extends HttpClientOperations
implements WebsocketInbound,
WebsocketOutbound,
BiConsumer<Void, Throwable> {
    final WebSocketClientHandshaker handshaker;
    final ChannelPromise handshakerResult;
    volatile int closeSent;
    static final AtomicIntegerFieldUpdater<HttpClientWSOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(HttpClientWSOperations.class, "closeSent");

    HttpClientWSOperations(URI currentURI, String protocols, HttpClientOperations replaced) {
        super(replaced.channel(), replaced);
        Channel channel = this.channel();
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(currentURI, WebSocketVersion.V13, protocols, true, replaced.requestHeaders().remove(HttpHeaderNames.HOST));
        this.handshakerResult = channel.newPromise();
        this.handshaker.handshake(channel).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            this.markPersistent(false);
            channel.read();
        }));
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public String selectedSubprotocol() {
        return this.handshaker.actualSubprotocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpResponse) {
            this.started = true;
            this.channel().pipeline().remove(HttpObjectAggregator.class);
            FullHttpResponse response = (FullHttpResponse)msg;
            this.setNettyResponse(response);
            if (this.checkResponseCode(response)) {
                try {
                    if (!this.handshaker.isHandshakeComplete()) {
                        this.handshaker.finishHandshake(this.channel(), response);
                    }
                }
                catch (WebSocketHandshakeException wshe) {
                    if (this.serverError) {
                        this.onInboundError(wshe);
                        return;
                    }
                }
                finally {
                    response.content().release();
                }
                this.parentContext().fireContextActive(this);
                this.handshakerResult.trySuccess();
            }
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            this.channel().writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            ctx.read();
            return;
        }
        if (msg instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)msg).isFinalFragment()) {
            if (log.isDebugEnabled()) {
                log.debug("CloseWebSocketFrame detected. Closing Websocket");
            }
            CloseWebSocketFrame close = (CloseWebSocketFrame)msg;
            this.sendClose(new CloseWebSocketFrame(true, close.rsv(), close.content()));
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    public WebsocketInbound receiveWebsocket() {
        return this;
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug("Cancelling Websocket inbound. Closing Websocket");
        }
        this.sendClose(null);
    }

    @Override
    protected void onInboundClose() {
        super.onInboundComplete();
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            this.sendClose(new CloseWebSocketFrame(1002, "Client internal error"));
        }
    }

    void sendClose(CloseWebSocketFrame frame) {
        if (frame != null && !frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            ChannelFuture f = this.channel().writeAndFlush(frame == null ? new CloseWebSocketFrame() : frame);
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void accept(Void aVoid, Throwable throwable) {
        if (log.isDebugEnabled()) {
            log.debug("Handler terminated. Closing Websocket");
        }
        if (throwable == null) {
            if (this.channel().isActive()) {
                this.sendClose(null);
            }
        } else {
            this.onOutboundError(throwable);
        }
    }
}

