/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http;

import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.ipc.netty.resources.PoolResources;
import io.micrometer.shaded.reactor.ipc.netty.tcp.TcpResources;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

public final class HttpResources
extends TcpResources {
    static final AtomicReference<HttpResources> httpResources;
    static final BiFunction<LoopResources, PoolResources, HttpResources> ON_HTTP_NEW;

    public static HttpResources get() {
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(PoolResources pools) {
        return HttpResources.getOrCreate(httpResources, null, pools, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(LoopResources loops) {
        return HttpResources.getOrCreate(httpResources, loops, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources reset() {
        HttpResources.shutdown();
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static void shutdown() {
        HttpResources resources = httpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> shutdownLater() {
        return Mono.defer(() -> {
            HttpResources resources = httpResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater();
            }
            return Mono.empty();
        });
    }

    HttpResources(LoopResources loops, PoolResources pools) {
        super(loops, pools);
    }

    static {
        ON_HTTP_NEW = HttpResources::new;
        httpResources = new AtomicReference();
    }
}

