/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandler;
import io.micrometer.shaded.io.netty.channel.CombinedChannelDuplexHandler;
import io.micrometer.shaded.io.netty.handler.codec.ByteToMessageCodec;
import io.micrometer.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpMessage;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpChunkedInput;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMessage;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedInput;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedNioFile;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.FutureMono;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.NettyInbound;
import io.micrometer.shaded.reactor.ipc.netty.NettyOutbound;
import io.micrometer.shaded.reactor.ipc.netty.NettyPipeline;
import io.micrometer.shaded.reactor.ipc.netty.channel.AbortedException;
import io.micrometer.shaded.reactor.ipc.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.ipc.netty.channel.ContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.channel.data.AbstractFileChunkedStrategy;
import io.micrometer.shaded.reactor.ipc.netty.channel.data.FileChunkedStrategy;
import io.micrometer.shaded.reactor.ipc.netty.http.HttpInfos;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;

public abstract class HttpOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
extends ChannelOperations<INBOUND, OUTBOUND>
implements HttpInfos {
    volatile int statusAndHeadersSent = 0;
    static final int READY = 0;
    static final int HEADERS_SENT = 1;
    static final int BODY_SENT = 2;
    static final AtomicIntegerFieldUpdater<HttpOperations> HTTP_STATE = AtomicIntegerFieldUpdater.newUpdater(HttpOperations.class, "statusAndHeadersSent");
    static final ChannelInboundHandler HTTP_EXTRACTOR = NettyPipeline.inboundHandler((ctx, msg) -> {
        if (msg instanceof ByteBufHolder) {
            ByteBuf bb = ((ByteBufHolder)msg).content();
            if (msg instanceof FullHttpMessage) {
                ctx.fireChannelRead(msg);
            } else {
                ctx.fireChannelRead(bb);
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    });

    protected HttpOperations(Channel ioChannel, HttpOperations<INBOUND, OUTBOUND> replaced) {
        super(ioChannel, replaced);
        this.statusAndHeadersSent = replaced.statusAndHeadersSent;
    }

    protected HttpOperations(Channel ioChannel, BiFunction<? super INBOUND, ? super OUTBOUND, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        super(ioChannel, handler, context);
        ioChannel.config().setAutoRead(false);
    }

    public final boolean hasSentHeaders() {
        return this.statusAndHeadersSent != 0;
    }

    @Override
    public boolean isWebsocket() {
        return false;
    }

    public NettyOutbound sendHeaders() {
        if (this.markSentHeaders()) {
            HttpMessage message;
            if (HttpUtil.isContentLengthSet(this.outboundHttpMessage())) {
                this.outboundHttpMessage().headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            }
            if (!(HttpUtil.isTransferEncodingChunked(this.outboundHttpMessage()) || HttpUtil.isContentLengthSet(this.outboundHttpMessage()) && HttpUtil.getContentLength(this.outboundHttpMessage(), 0) != 0)) {
                if (this.isKeepAlive() && this.markSentBody()) {
                    message = this.newFullEmptyBodyMessage();
                } else {
                    this.markPersistent(false);
                    message = this.outboundHttpMessage();
                }
            } else {
                message = this.outboundHttpMessage();
            }
            return this.then(FutureMono.deferFuture(() -> {
                if (!this.channel().isActive()) {
                    throw new AbortedException();
                }
                return this.channel().writeAndFlush(message);
            }));
        }
        return this;
    }

    @Override
    public Mono<Void> then() {
        if (this.markSentHeaders()) {
            if (HttpUtil.isContentLengthSet(this.outboundHttpMessage())) {
                this.outboundHttpMessage().headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            }
            if (!HttpUtil.isTransferEncodingChunked(this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet(this.outboundHttpMessage())) {
                this.markPersistent(false);
            }
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush(this.outboundHttpMessage()));
        }
        return Mono.empty();
    }

    protected abstract HttpMessage newFullEmptyBodyMessage();

    @Override
    public final NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.hasSentHeaders()) {
            return super.sendFile(file, position, count);
        }
        if (!HttpUtil.isTransferEncodingChunked(this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet(this.outboundHttpMessage()) && count < Integer.MAX_VALUE) {
            this.outboundHttpMessage().headers().setInt(HttpHeaderNames.CONTENT_LENGTH, (int)count);
        } else if (!HttpUtil.isContentLengthSet(this.outboundHttpMessage())) {
            this.outboundHttpMessage().headers().remove(HttpHeaderNames.CONTENT_LENGTH).remove(HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked(this.outboundHttpMessage(), true);
        }
        return super.sendFile(file, position, count);
    }

    @Override
    public FileChunkedStrategy getFileChunkedStrategy() {
        return new AbstractFileChunkedStrategy<HttpContent>(){

            @Override
            public ChunkedInput<HttpContent> chunkFile(FileChannel fileChannel) {
                try {
                    return new HttpChunkedInput(new ChunkedNioFile(fileChannel, 1024));
                }
                catch (IOException e) {
                    throw Exceptions.propagate(e);
                }
            }

            @Override
            public void afterWrite(NettyContext context) {
                HttpOperations.this.markSentBody();
            }
        };
    }

    @Override
    public String toString() {
        if (this.isWebsocket()) {
            return "ws:" + this.uri();
        }
        return this.method().name() + ":" + this.uri();
    }

    @Override
    public HttpOperations<INBOUND, OUTBOUND> addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        if (this.channel().pipeline().context(handler) == null) {
            return this;
        }
        HttpOperations.autoAddHttpExtractor(this, name, handler);
        return this;
    }

    static void autoAddHttpExtractor(NettyContext c, String name, ChannelHandler handler) {
        if (handler instanceof ByteToMessageDecoder || handler instanceof ByteToMessageCodec || handler instanceof CombinedChannelDuplexHandler) {
            String extractorName = name + "$extractor";
            if (c.channel().pipeline().context(extractorName) != null) {
                return;
            }
            c.channel().pipeline().addBefore(name, extractorName, HTTP_EXTRACTOR);
            if (NettyContext.isPersistent(c.channel())) {
                c.onClose(() -> c.removeHandler(extractorName));
            }
        }
    }

    protected final boolean markSentHeaders() {
        return HTTP_STATE.compareAndSet(this, 0, 1);
    }

    protected final boolean markSentBody() {
        return HTTP_STATE.compareAndSet(this, 1, 2);
    }

    protected final boolean markSentHeaderAndBody() {
        return HTTP_STATE.compareAndSet(this, 0, 2);
    }

    protected abstract HttpMessage outboundHttpMessage();
}

