/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.channel;

import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.micrometer.shaded.reactor.ipc.netty.channel.ContextHandler;

final class SslReadHandler
extends ChannelInboundHandlerAdapter {
    final ContextHandler<?> sink;
    boolean handshakeDone;

    SslReadHandler(ContextHandler<?> sink) {
        this.sink = sink;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (!this.handshakeDone) {
            ctx.read();
        }
        super.channelReadComplete(ctx);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshake;
            this.handshakeDone = true;
            if (ctx.pipeline().context(this) != null) {
                ctx.pipeline().remove(this);
            }
            if ((handshake = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                ctx.fireChannelActive();
            } else {
                this.sink.fireContextError(handshake.cause());
            }
        }
        super.userEventTriggered(ctx, evt);
    }
}

