/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoIgnoreElements;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;

final class MonoIgnorePublisher<T>
extends Mono<T>
implements Scannable {
    final Publisher<? extends T> source;

    MonoIgnorePublisher(Publisher<? extends T> source) {
        this.source = Objects.requireNonNull(source, "publisher");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new MonoIgnoreElements.IgnoreElementsSubscriber<T>(actual));
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }
}

