/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class StackdriverNamingConvention
implements NamingConvention {
    private static final int MAX_NAME_LENGTH = 200;
    private static final int MAX_TAG_KEY_LENGTH = 100;
    private static final int MAX_TAG_VALUE_LENGTH = 1024;
    private static final Pattern NAME_BLACKLIST = Pattern.compile("[^\\w./_]");
    private static final Pattern TAG_KEY_BLACKLIST = Pattern.compile("[^\\w_]");
    private final NamingConvention nameDelegate;
    private final NamingConvention tagKeyDelegate;

    public StackdriverNamingConvention() {
        this(NamingConvention.slashes, NamingConvention.snakeCase);
    }

    public StackdriverNamingConvention(NamingConvention nameDelegate, NamingConvention tagKeyDelegate) {
        this.nameDelegate = nameDelegate;
        this.tagKeyDelegate = tagKeyDelegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.sanitize(this.nameDelegate.name(name, type, baseUnit), NAME_BLACKLIST, 200);
    }

    private String sanitize(String value, Pattern blacklist, int maxLength) {
        return StringUtils.truncate((String)blacklist.matcher(value).replaceAll("_"), (int)maxLength);
    }

    public String tagKey(String key) {
        return this.sanitize(this.tagKeyDelegate.tagKey(key), TAG_KEY_BLACKLIST, 100);
    }

    public String tagValue(String value) {
        return StringUtils.truncate((String)value, (int)1024);
    }
}

