/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;

final class StackdriverHistogramUtil {
    private StackdriverHistogramUtil() {
    }

    static Histogram stackdriverHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig) {
        if (distributionStatisticConfig.isPublishingPercentiles()) {
            return new StackdriverClientSidePercentilesHistogram(clock, distributionStatisticConfig);
        }
        if (distributionStatisticConfig.isPublishingHistogram()) {
            return new StackdriverFixedBoundaryHistogram(clock, distributionStatisticConfig);
        }
        return new StackdriverInfinityBucketHistogram(clock, distributionStatisticConfig);
    }

    static class StackdriverClientSidePercentilesHistogram
    extends TimeWindowPercentileHistogram {
        StackdriverClientSidePercentilesHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig) {
            super(clock, distributionStatisticConfig, true, false, true);
        }
    }

    static class StackdriverFixedBoundaryHistogram
    extends TimeWindowFixedBoundaryHistogram {
        StackdriverFixedBoundaryHistogram(Clock clock, DistributionStatisticConfig config) {
            super(clock, config, true, false, true);
        }
    }

    static class StackdriverInfinityBucketHistogram
    extends TimeWindowFixedBoundaryHistogram {
        StackdriverInfinityBucketHistogram(Clock clock, DistributionStatisticConfig config) {
            super(clock, config, false, false, true);
        }
    }
}

