/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.Gauge;
import io.opentelemetry.proto.metrics.v1.Histogram;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.Summary;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;

class OtlpMetricConverter {
    private final Clock clock;
    private final Duration step;
    private final AggregationTemporality aggregationTemporality;
    private final io.opentelemetry.proto.metrics.v1.AggregationTemporality otlpAggregationTemporality;
    private final TimeUnit baseTimeUnit;
    private final NamingConvention namingConvention;
    private final Map<MetricMetaData, Metric.Builder> metricTypeBuilderMap = new HashMap<MetricMetaData, Metric.Builder>();
    private final long deltaTimeUnixNano;

    OtlpMetricConverter(Clock clock, Duration step, TimeUnit baseTimeUnit, AggregationTemporality aggregationTemporality, NamingConvention namingConvention) {
        this.clock = clock;
        this.step = step;
        this.aggregationTemporality = aggregationTemporality;
        this.otlpAggregationTemporality = AggregationTemporality.toOtlpAggregationTemporality(aggregationTemporality);
        this.baseTimeUnit = baseTimeUnit;
        this.namingConvention = namingConvention;
        this.deltaTimeUnixNano = clock.wallTime() / step.toMillis() * step.toNanos();
    }

    void addMeters(List<Meter> meters) {
        meters.forEach(this::addMeter);
    }

    void addMeter(Meter meter) {
        meter.use(this::writeGauge, this::writeCounter, this::writeHistogramSupport, this::writeHistogramSupport, this::writeHistogramSupport, this::writeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter);
    }

    List<Metric> getAllMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (Metric.Builder metricSet : this.metricTypeBuilderMap.values()) {
            metrics.add(metricSet.build());
        }
        return metrics;
    }

    private void writeMeter(Meter meter) {
        this.getOrCreateMetricBuilder(meter.getId(), Metric.DataCase.GAUGE);
    }

    private void writeGauge(io.micrometer.core.instrument.Gauge gauge) {
        Metric.Builder metricBuilder = this.getOrCreateMetricBuilder(gauge.getId(), Metric.DataCase.GAUGE);
        if (metricBuilder != null) {
            if (!metricBuilder.hasGauge()) {
                metricBuilder.setGauge(Gauge.newBuilder());
            }
            metricBuilder.getGaugeBuilder().addDataPoints(NumberDataPoint.newBuilder().setTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime())).setAsDouble(gauge.value()).addAllAttributes(this.getKeyValuesForId(gauge.getId())).build());
        }
    }

    private void writeCounter(Counter counter) {
        Metric.Builder metricBuilder = this.getOrCreateMetricBuilder(counter.getId(), Metric.DataCase.SUM);
        if (metricBuilder != null) {
            this.setSumDataPoint(metricBuilder, (Meter)counter, () -> ((Counter)counter).count());
        }
    }

    private void writeFunctionCounter(FunctionCounter functionCounter) {
        Metric.Builder metricBuilder = this.getOrCreateMetricBuilder(functionCounter.getId(), Metric.DataCase.SUM);
        if (metricBuilder != null) {
            this.setSumDataPoint(metricBuilder, (Meter)functionCounter, () -> ((FunctionCounter)functionCounter).count());
        }
    }

    private void writeHistogramSupport(HistogramSupport histogramSupport) {
        Meter.Id id = histogramSupport.getId();
        boolean isTimeBased = this.isTimeBasedMeter(id);
        HistogramSnapshot histogramSnapshot = histogramSupport.takeSnapshot();
        Iterable<KeyValue> tags = this.getKeyValuesForId(id);
        long startTimeNanos = this.getStartTimeNanos((Meter)histogramSupport);
        double total = isTimeBased ? histogramSnapshot.total(this.baseTimeUnit) : histogramSnapshot.total();
        long count = histogramSnapshot.count();
        if (histogramSnapshot.percentileValues().length != 0) {
            this.buildSummaryDataPoint(histogramSupport, tags, startTimeNanos, total, count, isTimeBased, histogramSnapshot);
        } else {
            this.buildHistogramDataPoint(histogramSupport, tags, startTimeNanos, total, count, isTimeBased, histogramSnapshot);
        }
    }

    private void writeFunctionTimer(FunctionTimer functionTimer) {
        Metric.Builder builder = this.getOrCreateMetricBuilder(functionTimer.getId(), Metric.DataCase.HISTOGRAM);
        if (builder != null) {
            HistogramDataPoint.Builder histogramDataPoint = HistogramDataPoint.newBuilder().addAllAttributes(this.getKeyValuesForId(functionTimer.getId())).setStartTimeUnixNano(this.getStartTimeNanos((Meter)functionTimer)).setTimeUnixNano(this.getTimeUnixNano()).setSum(functionTimer.totalTime(this.baseTimeUnit)).setCount((long)functionTimer.count());
            this.setHistogramDataPoint(builder, histogramDataPoint.build());
        }
    }

    private boolean isTimeBasedMeter(Meter.Id id) {
        return id.getType() == Meter.Type.TIMER || id.getType() == Meter.Type.LONG_TASK_TIMER;
    }

    private void buildHistogramDataPoint(HistogramSupport histogramSupport, Iterable<KeyValue> tags, long startTimeNanos, double total, long count, boolean isTimeBased, HistogramSnapshot histogramSnapshot) {
        Metric.Builder metricBuilder = this.getOrCreateMetricBuilder(histogramSupport.getId(), Metric.DataCase.HISTOGRAM);
        if (metricBuilder != null) {
            HistogramDataPoint.Builder histogramDataPoint = HistogramDataPoint.newBuilder().addAllAttributes(tags).setStartTimeUnixNano(startTimeNanos).setTimeUnixNano(this.getTimeUnixNano()).setSum(total).setCount(count);
            if (this.isDelta()) {
                histogramDataPoint.setMax(isTimeBased ? histogramSnapshot.max(this.baseTimeUnit) : histogramSnapshot.max());
            }
            for (CountAtBucket countAtBucket : histogramSnapshot.histogramCounts()) {
                if (countAtBucket.bucket() != Double.POSITIVE_INFINITY) {
                    histogramDataPoint.addExplicitBounds(isTimeBased ? countAtBucket.bucket(this.baseTimeUnit) : countAtBucket.bucket());
                }
                histogramDataPoint.addBucketCounts((long)countAtBucket.count());
            }
            this.setHistogramDataPoint(metricBuilder, histogramDataPoint.build());
        }
    }

    private void buildSummaryDataPoint(HistogramSupport histogramSupport, Iterable<KeyValue> tags, long startTimeNanos, double total, long count, boolean isTimeBased, HistogramSnapshot histogramSnapshot) {
        Metric.Builder metricBuilder = this.getOrCreateMetricBuilder(histogramSupport.getId(), Metric.DataCase.SUMMARY);
        if (metricBuilder != null) {
            SummaryDataPoint.Builder summaryDataPoint = SummaryDataPoint.newBuilder().addAllAttributes(tags).setStartTimeUnixNano(startTimeNanos).setTimeUnixNano(this.getTimeUnixNano()).setSum(total).setCount(count);
            for (ValueAtPercentile percentile : histogramSnapshot.percentileValues()) {
                double value = percentile.value();
                summaryDataPoint.addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(percentile.percentile()).setValue(isTimeBased ? TimeUtils.convert((double)value, (TimeUnit)TimeUnit.NANOSECONDS, (TimeUnit)this.baseTimeUnit) : value));
            }
            OtlpMetricConverter.setSummaryDataPoint(metricBuilder, summaryDataPoint);
        }
    }

    private void setSumDataPoint(Metric.Builder builder, Meter meter, DoubleSupplier count) {
        if (!builder.hasSum()) {
            builder.setSum(Sum.newBuilder().setIsMonotonic(true).setAggregationTemporality(this.otlpAggregationTemporality()));
        }
        builder.getSumBuilder().addDataPoints(NumberDataPoint.newBuilder().setStartTimeUnixNano(this.getStartTimeNanos(meter)).setTimeUnixNano(this.getTimeUnixNano()).setAsDouble(count.getAsDouble()).addAllAttributes(this.getKeyValuesForId(meter.getId())).build());
    }

    private void setHistogramDataPoint(Metric.Builder builder, HistogramDataPoint histogramDataPoint) {
        if (!builder.hasHistogram()) {
            builder.setHistogram(Histogram.newBuilder().setAggregationTemporality(this.otlpAggregationTemporality()));
        }
        builder.getHistogramBuilder().addDataPoints(histogramDataPoint);
    }

    private static void setSummaryDataPoint(Metric.Builder metricBuilder, SummaryDataPoint.Builder summaryDataPoint) {
        if (!metricBuilder.hasSummary()) {
            metricBuilder.setSummary(Summary.newBuilder());
        }
        metricBuilder.getSummaryBuilder().addDataPoints(summaryDataPoint);
    }

    private long getStartTimeNanos(Meter meter) {
        return this.isDelta() ? this.deltaTimeUnixNano - this.step.toNanos() : ((StartTimeAwareMeter)meter).getStartTimeNanos();
    }

    private long getTimeUnixNano() {
        return this.isDelta() ? this.deltaTimeUnixNano : TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime());
    }

    private boolean isDelta() {
        return this.aggregationTemporality == AggregationTemporality.DELTA;
    }

    private io.opentelemetry.proto.metrics.v1.AggregationTemporality otlpAggregationTemporality() {
        return this.otlpAggregationTemporality;
    }

    @Nullable
    Metric.Builder getOrCreateMetricBuilder(Meter.Id id, Metric.DataCase dataCase) {
        String conventionName = id.getConventionName(this.namingConvention);
        MetricMetaData metricMetaData = new MetricMetaData(dataCase, conventionName, id.getBaseUnit(), id.getDescription());
        Metric.Builder builder = this.metricTypeBuilderMap.get(metricMetaData);
        return builder != null ? builder : this.createMetricBuilder(metricMetaData);
    }

    private Metric.Builder createMetricBuilder(MetricMetaData metricMetaData) {
        Metric.Builder builder = Metric.newBuilder().setName(metricMetaData.getName());
        if (metricMetaData.getBaseUnit() != null) {
            builder.setUnit(metricMetaData.getBaseUnit());
        }
        if (metricMetaData.getDescription() != null) {
            builder.setDescription(metricMetaData.getDescription());
        }
        this.metricTypeBuilderMap.put(metricMetaData, builder);
        return builder;
    }

    private Iterable<KeyValue> getKeyValuesForId(Meter.Id id) {
        return id.getConventionTags(this.namingConvention).stream().map(tag -> OtlpMetricConverter.createKeyValue(tag.getKey(), tag.getValue())).collect(Collectors.toList());
    }

    private static KeyValue createKeyValue(String key, String value) {
        return KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value)).build();
    }

    private static class MetricMetaData {
        final Metric.DataCase dataCase;
        final String name;
        @Nullable
        final String baseUnit;
        @Nullable
        final String description;

        MetricMetaData(Metric.DataCase dataCase, String name, @Nullable String baseUnit, @Nullable String description) {
            this.dataCase = dataCase;
            this.name = name;
            this.baseUnit = baseUnit;
            this.description = description;
        }

        private String getName() {
            return this.name;
        }

        @Nullable
        private String getBaseUnit() {
            return this.baseUnit;
        }

        @Nullable
        private String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MetricMetaData)) {
                return false;
            }
            MetricMetaData that = (MetricMetaData)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.baseUnit, that.baseUnit) && Objects.equals(this.description, that.description) && Objects.equals(this.dataCase, that.dataCase);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.baseUnit, this.description, this.dataCase);
        }
    }
}

