/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.appoptics;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.time.Duration;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public interface AppOpticsConfig
extends StepRegistryConfig {
    public static final int MAX_BATCH_SIZE = 1000;
    public static final int DEFAULT_BATCH_SIZE = 500;

    default public String prefix() {
        return "appoptics";
    }

    default public String apiToken() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"apiToken").required().get();
    }

    default public @Nullable String hostTag() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"hostTag").orElse((Object)"instance");
    }

    default public String uri() {
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"uri").orElse((Object)"https://api.appoptics.com/v1/measurements");
    }

    default public boolean floorTimes() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"floorTimes").orElse((Object)false);
    }

    default public int batchSize() {
        return Math.min((Integer)PropertyValidator.getInteger((MeterRegistryConfig)this, (String)"batchSize").orElse((Object)500), 1000);
    }

    @Deprecated
    default public Duration connectTimeout() {
        return (Duration)PropertyValidator.getDuration((MeterRegistryConfig)this, (String)"connectTimeout").orElse((Object)Duration.ofSeconds(5L));
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"apiToken", AppOpticsConfig::apiToken), MeterRegistryConfigValidator.checkRequired((String)"uri", AppOpticsConfig::uri), MeterRegistryConfigValidator.check((String)"batchSize", AppOpticsConfig::batchSize).andThen(v -> v.invalidateWhen(b -> b > 1000, "cannot be greater than 1000", InvalidReason.MALFORMED))});
    }
}

