/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jetty12.client;

import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.http.Outcome;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Result;

public final class JettyClientTags {
    private static final Tag URI_ROOT = Tag.of((String)"uri", (String)"root");
    private static final Tag EXCEPTION_NONE = Tag.of((String)"exception", (String)"None");
    private static final Tag METHOD_UNKNOWN = Tag.of((String)"method", (String)"UNKNOWN");
    private static final Tag HOST_UNKNOWN = Tag.of((String)"host", (String)"UNKNOWN");
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    private JettyClientTags() {
    }

    public static Tag method(Request request) {
        return request != null ? Tag.of((String)"method", (String)request.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag host(Request request) {
        return request != null ? Tag.of((String)"host", (String)request.getHost()) : HOST_UNKNOWN;
    }

    public static Tag status(Result result) {
        return Tag.of((String)"status", (String)Integer.toString(result.getResponse().getStatus()));
    }

    public static Tag uri(Result result, Function<Result, String> successfulUriPattern) {
        String matchingPattern = successfulUriPattern.apply(result);
        if ((matchingPattern = MULTIPLE_SLASH_PATTERN.matcher(matchingPattern).replaceAll("/")).equals("/")) {
            return URI_ROOT;
        }
        matchingPattern = TRAILING_SLASH_PATTERN.matcher(matchingPattern).replaceAll("");
        return Tag.of((String)"uri", (String)matchingPattern);
    }

    public static Tag exception(Result result) {
        String simpleName;
        Throwable exception = result.getFailure();
        if (exception == null) {
            return EXCEPTION_NONE;
        }
        if (exception.getCause() != null) {
            exception = exception.getCause();
        }
        return Tag.of((String)"exception", (String)(StringUtils.isNotEmpty((String)(simpleName = exception.getClass().getSimpleName())) ? simpleName : exception.getClass().getName()));
    }

    public static Tag outcome(Result result) {
        return Outcome.forStatus((int)result.getResponse().getStatus()).asTag();
    }
}

