/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.java11.instrument.binder.jdk;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.java11.instrument.binder.jdk.HttpClientContext;
import io.micrometer.java11.instrument.binder.jdk.HttpClientObservationConvention;
import io.micrometer.java11.instrument.binder.jdk.HttpClientObservationDocumentation;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class DefaultHttpClientObservationConvention
implements HttpClientObservationConvention {
    public static final DefaultHttpClientObservationConvention INSTANCE = new DefaultHttpClientObservationConvention();

    public KeyValues getLowCardinalityKeyValues(HttpClientContext context) {
        if (context.getCarrier() == null) {
            return KeyValues.empty();
        }
        HttpRequest httpRequest = ((HttpRequest.Builder)context.getCarrier()).build();
        return KeyValues.of((KeyValue[])new KeyValue[]{HttpClientObservationDocumentation.LowCardinalityKeys.METHOD.withValue(httpRequest.method()), HttpClientObservationDocumentation.LowCardinalityKeys.URI.withValue(this.getUri(httpRequest, context.getUriMapper())), HttpClientObservationDocumentation.LowCardinalityKeys.STATUS.withValue(this.getStatus((HttpResponse)context.getResponse())), HttpClientObservationDocumentation.LowCardinalityKeys.OUTCOME.withValue(this.getOutcome((HttpResponse)context.getResponse()))});
    }

    String getUri(HttpRequest request, Function<HttpRequest, String> uriMapper) {
        return uriMapper.apply(request);
    }

    String getStatus(@Nullable HttpResponse<?> response) {
        if (response == null) {
            return "UNKNOWN";
        }
        return String.valueOf(response.statusCode());
    }

    String getOutcome(@Nullable HttpResponse<?> response) {
        if (response == null) {
            return Outcome.UNKNOWN.name();
        }
        return Outcome.forStatus((int)response.statusCode()).name();
    }

    public String getName() {
        return "http.client.requests";
    }

    public @Nullable String getContextualName(HttpClientContext context) {
        if (context.getCarrier() == null) {
            return null;
        }
        return "HTTP " + ((HttpRequest.Builder)context.getCarrier()).build().method();
    }
}

