/*
 * Decompiled with CFR 0.152.
 */
package io.michaelrocks.libphonenumber.android;

import io.michaelrocks.libphonenumber.android.CountryCodeToRegionCodeMap;
import io.michaelrocks.libphonenumber.android.MetadataLoader;
import io.michaelrocks.libphonenumber.android.MetadataManager;
import io.michaelrocks.libphonenumber.android.MetadataSource;
import io.michaelrocks.libphonenumber.android.Phonemetadata;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

final class MultiFileMetadataSourceImpl
implements MetadataSource {
    private final String phoneNumberMetadataFilePrefix;
    private final String alternateFormatsFilePrefix;
    private final String shortNumberFilePrefix;
    private final MetadataManager metadataManager;
    private final ConcurrentHashMap<String, Phonemetadata.PhoneMetadata> geographicalRegions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Phonemetadata.PhoneMetadata> nonGeographicalRegions = new ConcurrentHashMap();

    MultiFileMetadataSourceImpl(String phoneNumberMetadataFilePrefix, String alternateFormatsFilePrefix, String shortNumberFilePrefix, MetadataLoader metadataLoader) {
        this.phoneNumberMetadataFilePrefix = phoneNumberMetadataFilePrefix;
        this.alternateFormatsFilePrefix = alternateFormatsFilePrefix;
        this.shortNumberFilePrefix = shortNumberFilePrefix;
        this.metadataManager = new MetadataManager(metadataLoader);
    }

    MultiFileMetadataSourceImpl(MetadataLoader metadataLoader) {
        this("/io/michaelrocks/libphonenumber/android/data/PhoneNumberMetadataProto", "/io/michaelrocks/libphonenumber/android/data/PhoneNumberAlternateFormatsProto", "/io/michaelrocks/libphonenumber/android/data/ShortNumberMetadataProto", metadataLoader);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        return this.metadataManager.getMetadataFromMultiFilePrefix(regionCode, this.geographicalRegions, this.phoneNumberMetadataFilePrefix);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        if (!this.isNonGeographical(countryCallingCode)) {
            return null;
        }
        return this.metadataManager.getMetadataFromMultiFilePrefix(countryCallingCode, this.nonGeographicalRegions, this.phoneNumberMetadataFilePrefix);
    }

    @Override
    public Phonemetadata.PhoneMetadata getAlternateFormatsForCountry(int countryCallingCode) {
        return this.metadataManager.getAlternateFormatsForCountry(countryCallingCode, this.alternateFormatsFilePrefix);
    }

    @Override
    public Phonemetadata.PhoneMetadata getShortNumberMetadataForRegion(String regionCode) {
        return this.metadataManager.getShortNumberMetadataForRegion(regionCode, this.shortNumberFilePrefix);
    }

    private boolean isNonGeographical(int countryCallingCode) {
        List<String> regionCodes = CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap().get(countryCallingCode);
        return regionCodes.size() == 1 && "001".equals(regionCodes.get(0));
    }
}

