/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watcher.hashing.HashCode;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PathUtils {
    public static HashCode hash(FileHasher fileHasher, Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return HashCode.empty();
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return fileHasher.hash(path);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Map<WatchKey, Path> createKeyRootsMap() {
        return new ConcurrentHashMap<WatchKey, Path>();
    }

    public static Map<Path, HashCode> createHashCodeMap(Path path, FileHasher fileHasher) throws IOException {
        return PathUtils.createHashCodeMap(Collections.singletonList(path), fileHasher);
    }

    public static Map<Path, HashCode> createHashCodeMap(List<Path> list, FileHasher fileHasher) throws IOException {
        ConcurrentHashMap<Path, HashCode> concurrentHashMap = new ConcurrentHashMap<Path, HashCode>();
        if (fileHasher != null) {
            for (Path path : list) {
                for (Path path2 : PathUtils.recursiveListFiles(path)) {
                    HashCode hashCode = PathUtils.hash(fileHasher, path2);
                    if (hashCode == null) continue;
                    concurrentHashMap.put(path2, hashCode);
                }
            }
        }
        return concurrentHashMap;
    }

    public static Set<Path> recursiveListFiles(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        PathUtils.recursiveVisitFiles(path, hashSet::add, hashSet::add);
        return hashSet;
    }

    public static void recursiveVisitFiles(Path path, final PathCallback pathCallback, final PathCallback pathCallback2) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                pathCallback.call(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                pathCallback2.call(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }

    static interface PathCallback {
        public void call(Path var1) throws IOException;
    }
}

