/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher.hashing;

import io.methvin.watcher.hashing.HashCode;
import io.methvin.watcher.hashing.Murmur3F;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@FunctionalInterface
public interface FileHasher {
    public static final FileHasher DEFAULT_FILE_HASHER = path -> {
        Murmur3F murmur3F = new Murmur3F();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int n;
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                murmur3F.update(n);
            }
        }
        return HashCode.fromBytes(murmur3F.getValueBytesBigEndian());
    };

    public HashCode hash(Path var1) throws IOException;
}

