/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import com.google.common.hash.HashCode;
import com.sun.nio.file.ExtendedWatchEventModifier;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.PathUtils;
import io.methvin.watchservice.MacOSXListeningWatchService;
import io.methvin.watchservice.WatchablePath;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher {
    static final Logger logger = LoggerFactory.getLogger(DirectoryWatcher.class);
    private final WatchService watchService;
    private final List<Path> paths;
    private final boolean isMac;
    private final DirectoryChangeListener listener;
    private final Map<Path, HashCode> pathHashes;
    private final Map<WatchKey, Path> keyRoots;
    private Boolean fileTreeSupported = null;
    private boolean enableFileHashing;

    public static DirectoryWatcher create(Path path, DirectoryChangeListener directoryChangeListener) throws IOException {
        return DirectoryWatcher.create(Collections.singletonList(path), directoryChangeListener, true);
    }

    public static DirectoryWatcher create(List<Path> list, DirectoryChangeListener directoryChangeListener) throws IOException {
        return DirectoryWatcher.create(list, directoryChangeListener, true);
    }

    public static DirectoryWatcher create(List<Path> list, DirectoryChangeListener directoryChangeListener, boolean bl) throws IOException {
        boolean bl2 = System.getProperty("os.name").toLowerCase().contains("mac");
        WatchService watchService = bl2 ? new MacOSXListeningWatchService() : FileSystems.getDefault().newWatchService();
        return new DirectoryWatcher(list, directoryChangeListener, watchService, bl);
    }

    public DirectoryWatcher(List<Path> list, DirectoryChangeListener directoryChangeListener, WatchService watchService, boolean bl) throws IOException {
        this.paths = list;
        this.listener = directoryChangeListener;
        this.watchService = watchService;
        this.isMac = watchService instanceof MacOSXListeningWatchService;
        this.pathHashes = PathUtils.createHashCodeMap(list);
        this.keyRoots = PathUtils.createKeyRootsMap();
        this.enableFileHashing = bl;
        for (Path path : list) {
            this.registerAll(path);
        }
    }

    public CompletableFuture<Void> watchAsync() {
        return this.watchAsync(ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> watchAsync(Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            this.watch();
            return null;
        }, executor);
    }

    public void watch() {
        while (true) {
            WatchKey watchKey;
            if (!this.listener.isWatching()) {
                return;
            }
            try {
                watchKey = this.watchService.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                try {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    WatchEvent watchEvent2 = PathUtils.cast(watchEvent);
                    final int n = watchEvent2.count();
                    Path path = (Path)watchEvent2.context();
                    if (!this.keyRoots.containsKey(watchKey)) {
                        throw new IllegalStateException("WatchService returned key [" + watchKey + "] but it was not found in keyRoots!");
                    }
                    Path path2 = path == null ? null : this.keyRoots.get(watchKey).resolve(path);
                    logger.debug("{} [{}]", kind, (Object)path2);
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.OVERFLOW, path2, n));
                        continue;
                    }
                    if (path == null) {
                        throw new IllegalStateException("WatchService returned a null path for " + kind.name());
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        if (Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS)) {
                            if (!Boolean.TRUE.equals(this.fileTreeSupported)) {
                                this.registerAll(path2);
                            }
                            if (!this.isMac) {
                                Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                        DirectoryWatcher.this.notifyCreateEvent(path, n);
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                        DirectoryWatcher.this.notifyCreateEvent(path, n);
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                            }
                        }
                        this.notifyCreateEvent(path2, n);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        if (this.enableFileHashing || Files.isDirectory(path2, new LinkOption[0])) {
                            HashCode hashCode = this.pathHashes.get(path2);
                            HashCode hashCode2 = PathUtils.hash(path2);
                            if (hashCode2 != null && !hashCode2.equals((Object)hashCode)) {
                                this.pathHashes.put(path2, hashCode2);
                                this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.MODIFY, path2, n));
                                continue;
                            }
                            if (hashCode2 != null) continue;
                            logger.debug("Failed to hash modified file [{}]. It may have been deleted.", (Object)path2);
                            continue;
                        }
                        this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.MODIFY, path2, n));
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    this.pathHashes.remove(path2);
                    this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.DELETE, path2, n));
                }
                catch (Exception exception) {
                    this.listener.onException(exception);
                }
            }
            boolean bl = watchKey.reset();
            if (bl) continue;
            logger.debug("WatchKey for [{}] no longer valid; removing.", (Object)watchKey.watchable());
            this.keyRoots.remove(watchKey);
            if (this.keyRoots.isEmpty()) break;
        }
        logger.debug("No more directories left to watch; terminating watcher.");
    }

    public DirectoryChangeListener getListener() {
        return this.listener;
    }

    public void close() throws IOException {
        this.watchService.close();
    }

    private void registerAll(Path path) throws IOException {
        if (!Boolean.FALSE.equals(this.fileTreeSupported)) {
            try {
                this.register(path, true);
                this.fileTreeSupported = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.debug("Assuming ExtendedWatchEventModifier.FILE_TREE is not supported", (Throwable)unsupportedOperationException);
                this.fileTreeSupported = false;
                this.registerAll(path);
            }
        } else {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    DirectoryWatcher.this.register(path, false);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void register(Path path, boolean bl) throws IOException {
        WatchEvent.Modifier[] modifierArray;
        Watchable watchable;
        logger.debug("Registering [{}].", (Object)path);
        Watchable watchable2 = watchable = this.isMac ? new WatchablePath(path) : path;
        if (bl) {
            WatchEvent.Modifier[] modifierArray2 = new WatchEvent.Modifier[1];
            modifierArray = modifierArray2;
            modifierArray2[0] = ExtendedWatchEventModifier.FILE_TREE;
        } else {
            modifierArray = new WatchEvent.Modifier[]{};
        }
        WatchEvent.Modifier[] modifierArray3 = modifierArray;
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        WatchKey watchKey = watchable.register(this.watchService, kindArray, modifierArray3);
        this.keyRoots.put(watchKey, path);
    }

    private void notifyCreateEvent(Path path, int n) throws IOException {
        if (this.enableFileHashing || Files.isDirectory(path, new LinkOption[0])) {
            HashCode hashCode = PathUtils.hash(path);
            if (hashCode == null) {
                logger.debug("Failed to hash created file [{}]. It may have been deleted.", (Object)path);
                return;
            }
            if (!this.pathHashes.containsKey(path)) {
                logger.debug("{} [{}]", (Object)DirectoryChangeEvent.EventType.CREATE, (Object)path);
                this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.CREATE, path, n));
                this.pathHashes.put(path, hashCode);
            }
        } else {
            logger.debug("{} [{}]", (Object)DirectoryChangeEvent.EventType.CREATE, (Object)path);
            this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.CREATE, path, n));
        }
    }
}

