/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watchservice;

import io.methvin.watchservice.AbstractWatchService;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

class AbstractWatchKey
implements WatchKey {
    private final AbstractWatchService watcher;
    private final Watchable watchable;
    private final Set<WatchEvent.Kind<?>> subscribedTypes;
    private final AtomicReference<State> state = new AtomicReference<State>(State.READY);
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final AtomicInteger overflow = new AtomicInteger();
    private final BlockingQueue<WatchEvent<?>> events;

    private static WatchEvent<Object> overflowEvent(int n) {
        return new AbstractWatchService.Event<Object>(StandardWatchEventKinds.OVERFLOW, n, null);
    }

    public AbstractWatchKey(AbstractWatchService abstractWatchService, @Nullable Watchable watchable, Iterable<? extends WatchEvent.Kind<?>> iterable, int n) {
        this.watcher = Objects.requireNonNull(abstractWatchService);
        this.watchable = watchable;
        this.events = new ArrayBlockingQueue(n);
        HashSet hashSet = new HashSet();
        iterable.forEach(hashSet::add);
        this.subscribedTypes = Collections.unmodifiableSet(hashSet);
    }

    State state() {
        return this.state.get();
    }

    public boolean subscribesTo(WatchEvent.Kind<?> kind) {
        return this.subscribedTypes.contains(kind);
    }

    public void post(WatchEvent<?> watchEvent) {
        if (!this.events.offer(watchEvent)) {
            this.overflow.incrementAndGet();
        }
    }

    public void signal() {
        if (this.state.getAndSet(State.SIGNALLED) == State.READY) {
            this.watcher.enqueue(this);
        }
    }

    @Override
    public boolean isValid() {
        return this.watcher.isOpen() && this.valid.get();
    }

    @Override
    public List<WatchEvent<?>> pollEvents() {
        ArrayList<WatchEvent<Object>> arrayList = new ArrayList<WatchEvent<Object>>(this.events.size());
        this.events.drainTo(arrayList);
        int n = this.overflow.getAndSet(0);
        if (n != 0) {
            arrayList.add(AbstractWatchKey.overflowEvent(n));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean reset() {
        if (this.isValid() && this.state.compareAndSet(State.SIGNALLED, State.READY) && !this.events.isEmpty()) {
            this.signal();
        }
        return this.isValid();
    }

    @Override
    public void cancel() {
        this.valid.set(false);
        this.watcher.cancelled(this);
    }

    @Override
    public Watchable watchable() {
        return this.watchable;
    }

    final void signalEvent(WatchEvent.Kind<Path> kind, Path path) {
        this.post(new AbstractWatchService.Event<Path>(kind, 1, path));
        this.signal();
    }

    static enum State {
        READY,
        SIGNALLED;

    }
}

