/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PathUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.goodFastHash((int)64);

    public static HashCode hash(Path path) {
        try {
            File file = path.toFile();
            if (!file.isDirectory()) {
                if (!file.exists()) {
                    return null;
                }
                return Files.hash((File)path.toFile(), (HashFunction)HASH_FUNCTION);
            }
            return HASH_FUNCTION.newHasher().putString((CharSequence)path.toString(), Charsets.UTF_8).hash();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Map<WatchKey, Path> createKeyRootsMap() {
        return new ConcurrentHashMap<WatchKey, Path>();
    }

    public static Map<Path, HashCode> createHashCodeMap(Path path) {
        return PathUtils.createHashCodeMap(Collections.singletonList(path));
    }

    public static Map<Path, HashCode> createHashCodeMap(List<Path> list) {
        ConcurrentHashMap<Path, HashCode> concurrentHashMap = new ConcurrentHashMap<Path, HashCode>();
        for (Path path : list) {
            for (Path path2 : PathUtils.recursiveListFiles(path)) {
                HashCode hashCode = PathUtils.hash(path2);
                if (hashCode == null) continue;
                concurrentHashMap.put(path2, hashCode);
            }
        }
        return concurrentHashMap;
    }

    public static Set<Path> recursiveListFiles(Path path) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        if (path.toFile().isDirectory()) {
            for (File file : path.toFile().listFiles()) {
                hashSet.addAll(PathUtils.recursiveListFiles(file.toPath()));
            }
        }
        return hashSet;
    }

    public static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }
}

