/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import com.google.common.hash.HashCode;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.PathUtils;
import io.methvin.watchservice.MacOSXListeningWatchService;
import io.methvin.watchservice.WatchablePath;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public class DirectoryWatcher {
    private final WatchService watchService;
    private final List<Path> paths;
    private final boolean isMac;
    private final DirectoryChangeListener listener;
    private final Map<Path, HashCode> pathHashes;
    private final Map<WatchKey, Path> keyRoots;

    public static DirectoryWatcher create(Path path, DirectoryChangeListener directoryChangeListener) throws IOException {
        return DirectoryWatcher.create(Collections.singletonList(path), directoryChangeListener);
    }

    public static DirectoryWatcher create(List<Path> list, DirectoryChangeListener directoryChangeListener) throws IOException {
        boolean bl = System.getProperty("os.name").toLowerCase().contains("mac");
        WatchService watchService = bl ? new MacOSXListeningWatchService() : FileSystems.getDefault().newWatchService();
        return new DirectoryWatcher(list, directoryChangeListener, watchService);
    }

    public DirectoryWatcher(List<Path> list, DirectoryChangeListener directoryChangeListener, WatchService watchService) throws IOException {
        this.paths = list;
        this.listener = directoryChangeListener;
        this.watchService = watchService;
        this.isMac = watchService instanceof MacOSXListeningWatchService;
        this.pathHashes = PathUtils.createHashCodeMap(list);
        this.keyRoots = PathUtils.createKeyRootsMap();
        for (Path path : list) {
            this.registerAll(path);
        }
    }

    public CompletableFuture<Void> watchAsync() {
        return this.watchAsync(ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> watchAsync(Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.watch();
                return null;
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException while watching", iOException);
            }
        }, executor);
    }

    public void watch() throws IOException {
        WatchKey watchKey;
        boolean bl;
        do {
            if (!this.listener.isWatching()) {
                return;
            }
            try {
                watchKey = this.watchService.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                WatchEvent.Kind<?> kind = watchEvent.kind();
                WatchEvent watchEvent2 = PathUtils.cast(watchEvent);
                int n = watchEvent2.count();
                Path path = (Path)watchEvent2.context();
                if (!this.keyRoots.containsKey(watchKey)) {
                    throw new IllegalStateException("WatchService returned key [" + watchKey + "] but it was not found in keyRoots!");
                }
                Path path2 = this.keyRoots.get(watchKey).resolve(path);
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.OVERFLOW, path2, n));
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    if (Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS)) {
                        this.registerAll(path2);
                        continue;
                    }
                    this.pathHashes.put(path2, PathUtils.hash(path2));
                    this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.CREATE, path2, n));
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    HashCode hashCode = this.pathHashes.get(path2);
                    HashCode hashCode2 = PathUtils.hash(path2);
                    if (hashCode == null || hashCode2 == null || hashCode.equals((Object)hashCode2)) continue;
                    this.pathHashes.put(path2, hashCode2);
                    this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.MODIFY, path2, n));
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this.pathHashes.remove(path2);
                this.listener.onEvent(new DirectoryChangeEvent(DirectoryChangeEvent.EventType.DELETE, path2, n));
            }
        } while (bl = watchKey.reset());
    }

    private void register(Path path) throws IOException {
        Watchable watchable = this.isMac ? new WatchablePath(path) : path;
        this.keyRoots.put(watchable.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), path);
    }

    public DirectoryChangeListener getListener() {
        return this.listener;
    }

    public void close() throws IOException {
        this.watchService.close();
    }

    private void registerAll(Path path) throws IOException {
        if (this.isMac) {
            this.register(path);
        } else {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    DirectoryWatcher.this.register(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

