/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.inject.Inject;
import io.mangoo.annotations.FilterWith;
import io.mangoo.filters.AuthenticityFilter;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import java.util.UUID;
import models.User;
import services.DataService;

public class AuthenticationController {
    private static final String PASSWORD = "password";
    private static final String USERNAME = "username";
    private DataService dataService;

    @Inject
    public AuthenticationController(DataService dataService) {
        this.dataService = dataService;
    }

    public Response login() {
        return Response.withOk();
    }

    @FilterWith(value={AuthenticityFilter.class})
    public Response authenticate(Form form, Flash flash, Authentication authentication) {
        User user;
        form.expectValue(USERNAME);
        form.expectValue(PASSWORD);
        if (form.isValid() && (user = this.dataService.getUser()) != null && authentication.validLogin(form.get(USERNAME), form.get(PASSWORD), user.getPassword())) {
            authentication.login(UUID.randomUUID().toString()).rememberMe(form.getBoolean("remember").orElse(Boolean.FALSE).booleanValue());
            return Response.withRedirect((String)"/");
        }
        return Response.withRedirect((String)"/login");
    }

    @FilterWith(value={AuthenticityFilter.class})
    public Response logout(Authentication authentication) {
        authentication.logout();
        return Response.withRedirect((String)"/");
    }
}

