/*
 * Decompiled with CFR 0.152.
 */
package io.logmatic.android.endpoint;

import android.util.Log;
import io.logmatic.android.endpoint.Endpoint;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class TCPEndpoint
implements Endpoint {
    private Socket socket;
    private DataOutputStream stream;
    private final String hostname;
    private final Integer port;

    public TCPEndpoint(String hostname, Integer port) {
        this.port = port;
        this.hostname = hostname;
        this.socket = null;
    }

    @Override
    public boolean send(String data) {
        if (!this.isConnected()) {
            return false;
        }
        try {
            this.stream.write(data.getBytes());
            return true;
        }
        catch (IOException e) {
            Log.e((String)this.getClass().getName(), (String)"Failed to send data to the endpoint", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean flush() {
        try {
            this.stream.flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public void closeConnection() {
        try {
            this.stream.flush();
            this.stream.close();
            this.socket.close();
        }
        catch (IOException e) {
            Log.e((String)this.getClass().getName(), (String)"Connection shutdown failed", (Throwable)e);
        }
        catch (NullPointerException ne) {
            Log.v((String)this.getClass().getName(), (String)"Connection shutdown failed, no previous connection have been open");
        }
    }

    @Override
    public boolean openConnection() {
        try {
            if (this.socket == null || this.socket.isClosed()) {
                this.socket = new Socket(this.hostname, (int)this.port);
            }
            this.stream = new DataOutputStream(this.socket.getOutputStream());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)this.getClass().getName(), (String)"Failed to open socket", (Throwable)e);
            return false;
        }
    }
}

