/*
 * Decompiled with CFR 0.152.
 */
package io.logmatic.android;

import android.os.Build;
import android.util.Log;
import io.logmatic.android.EndpointManager;
import io.logmatic.android.endpoint.SecureTCPEndpoint;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LogmaticAppender {
    private static final long IDLE_TIME_SECONDS = 60L;
    private final String token;
    private boolean isConnected = true;
    private EndpointManager manager;
    ScheduledThreadPoolExecutor scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
    private Deque<String> cache;

    public LogmaticAppender(String token, EndpointManager manager) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.cache = new ConcurrentLinkedDeque<String>();
            Log.i((String)"logmatic", (String)"Instantiate a ConcurrentLinkedDeque for the deque");
        } else {
            this.cache = new ArrayDeque<String>();
            Log.w((String)"logmatic", (String)"Instantiate a ArrayDeque for the deque");
        }
        Log.i((String)this.getClass().getSimpleName(), (String)("Network state initialization, isConnected: " + this.isConnected));
        if (manager == null) {
            SecureTCPEndpoint endpoint = new SecureTCPEndpoint("api.logmatic.io", 10515);
            this.manager = new EndpointManager(endpoint);
        }
        this.token = token;
        this.start();
    }

    public final void start() {
        Runnable periodicCronTask = new Runnable(){

            @Override
            public void run() {
                LogmaticAppender.this.tick();
            }
        };
        this.scheduler.scheduleAtFixedRate(periodicCronTask, 0L, 60L, TimeUnit.SECONDS);
    }

    public final void stop() {
        this.tick();
        this.scheduler.shutdownNow();
        this.manager.shutdown();
    }

    public void append(String data) {
        this.cache.offer(this.token + ' ' + data + '\n');
    }

    public void tick() {
        Log.v((String)"logmatic", (String)"cron - tick()");
        if (!this.isConnected || this.cache.isEmpty()) {
            return;
        }
        Log.d((String)"logmatic", (String)"Start a new async task to send events to Logmation.io");
        this.manager.doInBackground(this.cache);
    }

    public void updateNetworkStatus(boolean isConnected) {
        Log.d((String)"logmatic", (String)("Network status changed, isConnected: " + isConnected));
        this.isConnected = isConnected;
    }
}

