/*
 * Decompiled with CFR 0.152.
 */
package io.logmatic.android;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.logmatic.android.Logger;
import io.logmatic.android.LoggerRegistry;
import io.logmatic.android.LogmaticAppender;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LoggerBuilder {
    public static final String DEFAULT_LOGGERNAME = "android";
    private String token;
    private LogmaticAppender appender;
    private boolean timestamping = true;
    private boolean legacyLogging = true;
    private String name = "android";
    private Set<Map.Entry<String, JsonElement>> extraFields = new HashSet<Map.Entry<String, JsonElement>>();
    private static final Gson gson = new GsonBuilder().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public LoggerBuilder init(String youLogmaticKey) {
        this.token = youLogmaticKey;
        return this;
    }

    public LoggerBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public LoggerBuilder setCustomAppender(LogmaticAppender appender) {
        this.appender = appender;
        return this;
    }

    public LoggerBuilder disableTimestamping() {
        this.timestamping = false;
        return this;
    }

    public LoggerBuilder disableLegacyLogging() {
        this.legacyLogging = false;
        return this;
    }

    public void addField(String key, String value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Long value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Integer value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Float value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Double value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Boolean value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Date value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value.getTime())));
    }

    public Logger build() {
        if (this.appender == null) {
            this.appender = new LogmaticAppender(this.token, null);
        }
        Logger l = new Logger(this.name, this.appender, this.timestamping, this.legacyLogging, this.extraFields);
        LoggerRegistry.register(this.name, l);
        return l;
    }
}

