/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.strategy;

import io.github.classgraph.ClassInfo;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.mapping.strategy.ImplementationDiscoveryStrategy;
import io.leangen.graphql.util.ClassFinder;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DefaultImplementationDiscoveryStrategy
implements ImplementationDiscoveryStrategy {
    private final List<Predicate<ClassInfo>> filters = new ArrayList<Predicate<ClassInfo>>();

    public DefaultImplementationDiscoveryStrategy() {
        this.filters.add(ClassFinder.PUBLIC);
    }

    @Override
    public List<AnnotatedType> findImplementations(AnnotatedType type, String[] scanPackages, BuildContext buildContext) {
        if (Utils.isArrayEmpty(scanPackages) && Utils.isArrayNotEmpty(buildContext.basePackages)) {
            scanPackages = buildContext.basePackages;
        }
        Predicate<ClassInfo> filter = ClassFinder.NON_IGNORED.and(this.filters.stream().reduce(Predicate::and).orElse(ClassFinder.ALL));
        return buildContext.classFinder.findImplementations(type, filter, scanPackages).stream().filter(impl -> !ClassUtils.isMissingTypeParameters(impl.getType())).collect(Collectors.toList());
    }

    public DefaultImplementationDiscoveryStrategy withNonPublicClasses() {
        this.filters.remove(ClassFinder.PUBLIC);
        return this;
    }

    @SafeVarargs
    public final DefaultImplementationDiscoveryStrategy withFilters(Predicate<ClassInfo> ... filters) {
        Collections.addAll(this.filters, filters);
        return this;
    }
}

