/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.leangen.graphql.annotations.GraphQLIgnore;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.SchemaTransformer;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.metadata.DirectiveArgument;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLIgnore
public class NonNullMapper
implements TypeMapper,
Comparator<AnnotatedType>,
SchemaTransformer {
    private final Set<Class<? extends Annotation>> nonNullAnnotations;
    private static final Logger log = LoggerFactory.getLogger(NonNullMapper.class);
    private static final String[] COMMON_NON_NULL_ANNOTATIONS = new String[]{"javax.annotation.Nonnull", "javax.validation.constraints.NotNull", "javax.validation.constraints.NotEmpty", "javax.validation.constraints.NotBlank"};

    public NonNullMapper() {
        HashSet annotations = new HashSet();
        annotations.add(io.leangen.graphql.annotations.GraphQLNonNull.class);
        for (String additional : COMMON_NON_NULL_ANNOTATIONS) {
            try {
                annotations.add(ClassUtils.forName(additional));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.nonNullAnnotations = Collections.unmodifiableSet(annotations);
    }

    public GraphQLNonNull toGraphQLType(AnnotatedType javaType, OperationMapper operationMapper, Set<Class<? extends TypeMapper>> mappersToSkip, BuildContext buildContext) {
        mappersToSkip.add(this.getClass());
        GraphQLOutputType inner = operationMapper.toGraphQLType(javaType, mappersToSkip, buildContext);
        return inner instanceof GraphQLNonNull ? (GraphQLNonNull)inner : new GraphQLNonNull((GraphQLType)inner);
    }

    public GraphQLNonNull toGraphQLInputType(AnnotatedType javaType, OperationMapper operationMapper, Set<Class<? extends TypeMapper>> mappersToSkip, BuildContext buildContext) {
        mappersToSkip.add(this.getClass());
        GraphQLInputType inner = operationMapper.toGraphQLInputType(javaType, mappersToSkip, buildContext);
        return inner instanceof GraphQLNonNull ? (GraphQLNonNull)inner : new GraphQLNonNull((GraphQLType)inner);
    }

    @Override
    public GraphQLFieldDefinition transformField(GraphQLFieldDefinition field, Operation operation, OperationMapper operationMapper, BuildContext buildContext) {
        if (this.shouldWrap((GraphQLType)field.getType(), operation.getTypedElement())) {
            return field.transform(builder -> builder.type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)field.getType())));
        }
        return field;
    }

    @Override
    public GraphQLInputObjectField transformInputField(GraphQLInputObjectField field, InputField inputField, OperationMapper operationMapper, BuildContext buildContext) {
        if (field.getDefaultValue() == null && this.shouldWrap((GraphQLType)field.getType(), inputField.getTypedElement())) {
            return field.transform(builder -> builder.type((GraphQLInputType)new GraphQLNonNull((GraphQLType)field.getType())));
        }
        if (this.shouldUnwrap(field.getDefaultValue(), (GraphQLType)field.getType())) {
            if (!ClassUtils.getRawType(inputField.getJavaType().getType()).isPrimitive()) {
                log.warn("Non-null input field with a default value will be treated as nullable: " + inputField);
            }
            return field.transform(builder -> builder.type((GraphQLInputType)GraphQLUtils.unwrapNonNull((GraphQLType)field.getType())));
        }
        return field;
    }

    @Override
    public GraphQLArgument transformArgument(GraphQLArgument argument, OperationArgument operationArgument, OperationMapper operationMapper, BuildContext buildContext) {
        return this.transformArgument(argument, operationArgument.getTypedElement(), operationArgument.toString(), operationMapper, buildContext);
    }

    @Override
    public GraphQLArgument transformArgument(GraphQLArgument argument, DirectiveArgument directiveArgument, OperationMapper operationMapper, BuildContext buildContext) {
        if (directiveArgument.getAnnotation() != null && directiveArgument.getDefaultValue() == null) {
            return argument.transform(builder -> builder.type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)argument.getType())));
        }
        return this.transformArgument(argument, directiveArgument.getTypedElement(), directiveArgument.toString(), operationMapper, buildContext);
    }

    private GraphQLArgument transformArgument(GraphQLArgument argument, TypedElement element, String description, OperationMapper operationMapper, BuildContext buildContext) {
        if (argument.getDefaultValue() == null && this.shouldWrap((GraphQLType)argument.getType(), element)) {
            return argument.transform(builder -> builder.type((GraphQLInputType)new GraphQLNonNull((GraphQLType)argument.getType())));
        }
        if (this.shouldUnwrap(argument.getDefaultValue(), (GraphQLType)argument.getType())) {
            if (!ClassUtils.getRawType(element.getJavaType().getType()).isPrimitive()) {
                log.warn("Non-null argument with a default value will be treated as nullable: " + description);
            }
            return argument.transform(builder -> builder.type((GraphQLInputType)GraphQLUtils.unwrapNonNull((GraphQLType)argument.getType())));
        }
        return argument;
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return this.nonNullAnnotations.stream().anyMatch(type::isAnnotationPresent) || ClassUtils.getRawType(type.getType()).isPrimitive();
    }

    @Override
    public int compare(AnnotatedType o1, AnnotatedType o2) {
        return ClassUtils.removeAnnotations(o1, this.nonNullAnnotations).equals(ClassUtils.removeAnnotations(o2, this.nonNullAnnotations)) ? 0 : -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldWrap(GraphQLType type, TypedElement typedElement) {
        if (type instanceof GraphQLNonNull) return false;
        if (!this.nonNullAnnotations.stream().anyMatch(typedElement::isAnnotationPresent)) return false;
        return true;
    }

    private boolean shouldUnwrap(Object defaultValue, GraphQLType type) {
        return defaultValue != null && type instanceof GraphQLNonNull;
    }
}

